/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.actions;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.BeanClassQuery;

public class FindBeansForClassAction
extends Action
implements IViewActionDelegate {
    private ISelection selection;

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        String className = this.getSelectedClassName();
        if (className != null) {
            BeansSearchScope scope = BeansSearchScope.newSearchScope();
            BeanClassQuery query = new BeanClassQuery(scope, className, true, false);
            NewSearchUI.activateSearchResultView();
            NewSearchUI.runQueryInBackground((ISearchQuery)query);
        }
    }

    private String getSelectedClassName() {
        if (this.selection instanceof IStructuredSelection && !this.selection.isEmpty()) {
            Object obj = ((IStructuredSelection)this.selection).getFirstElement();
            if (obj instanceof IType) {
                return ((IType)obj).getFullyQualifiedName();
            }
            if (obj instanceof ICompilationUnit) {
                return ((ICompilationUnit)obj).findPrimaryType().getFullyQualifiedName();
            }
            if (obj instanceof IClassFile) {
                try {
                    return ((IClassFile)obj).getType().getFullyQualifiedName();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }
}

