/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core;

import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GitHubAttributeMetadata {
    private String id;
    private String label;
    private String type;
    private String kind;
    private boolean readOnly;
    private boolean initTask;

    public GitHubAttributeMetadata(String id, String label, String type, boolean readOnly) {
        this(id, label, type, readOnly, false);
    }

    public GitHubAttributeMetadata(String id, String label, String type, boolean readOnly, boolean initTask) {
        this(id, label, "task.common.kind.default", type, readOnly, initTask);
    }

    public GitHubAttributeMetadata(String id, String label, String kind, String type, boolean readOnly, boolean initTask) {
        this.id = id;
        this.label = label;
        this.kind = kind;
        this.type = type;
        this.readOnly = readOnly;
        this.initTask = initTask;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getType() {
        return this.type;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isInitTask() {
        return this.initTask;
    }

    public TaskAttribute create(TaskData data) {
        return this.create(data.getRoot());
    }

    public TaskAttribute create(TaskAttribute parent) {
        TaskAttribute attribute = new TaskAttribute(parent, this.id);
        attribute.getMetaData().defaults().setLabel(this.label).setType(this.type).setKind(this.kind).setReadOnly(this.readOnly);
        return attribute;
    }

    public String getValue(TaskData data) {
        TaskAttribute root = data.getRoot();
        TaskAttribute attribute = root.getAttribute(this.id);
        return attribute != null ? data.getAttributeMapper().getValue(attribute) : "";
    }

    public void setValue(TaskData data, String value) {
        TaskAttribute attribute;
        TaskAttribute root = data.getRoot();
        if (value == null) {
            value = "";
        }
        if ((attribute = root.getAttribute(this.id)) != null) {
            data.getAttributeMapper().setValue(attribute, value);
        }
    }
}

