/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.AbstractPMDPagebookView;
import net.sourceforge.pmd.eclipse.ui.views.AbstractStructureInspectorPage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractResourceView
extends AbstractPMDPagebookView
implements IResourceChangeListener {
    protected static boolean getBoolUIPref(String prefId) {
        return AbstractResourceView.pStore().getBoolean(prefId);
    }

    protected static IPreferenceStore pStore() {
        return PMDPlugin.getDefault().getPreferenceStore();
    }

    protected AbstractResourceView() {
    }

    protected abstract AbstractStructureInspectorPage getCurrentViewPage();

    public void partActivated(IWorkbenchPart part) {
        IWorkbenchPart activePart = this.getSitePage().getActivePart();
        if (activePart == null) {
            this.getSitePage().activate((IWorkbenchPart)this);
        }
        super.partActivated(part);
    }

    protected IPath getResourcePath() {
        AbstractStructureInspectorPage page = this.getCurrentViewPage();
        FileRecord record = page.getFileRecord();
        IResource resource = record.getResource();
        return resource.getFullPath();
    }

    protected void setUIPref(String prefId, boolean flag) {
        AbstractResourceView.pStore().setValue(prefId, flag);
    }

    protected void setupListener(FileRecord resourceRecord) {
        resourceRecord.getResource().getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        AbstractStructureInspectorPage page;
        FileRecord resourceRecord = this.getFileRecordFromWorkbenchPart(part);
        if (resourceRecord != null) {
            resourceRecord.getResource().getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
        if ((page = (AbstractStructureInspectorPage)pageRecord.page) != null) {
            page.dispose();
        }
        pageRecord.dispose();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(final IResourceDelta delta) throws CoreException {
                    IPath path = AbstractResourceView.this.getResourcePath();
                    if (delta.getFullPath().equals((Object)path)) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                AbstractResourceView.this.refresh(delta.getResource());
                            }
                        });
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            PMDPlugin.getDefault().logError("message.error.core_exception", e);
        }
    }

    protected void refresh(IResource newResource) {
        AbstractStructureInspectorPage page = this.getCurrentViewPage();
        if (page != null) {
            page.refresh(newResource);
        }
    }
}

