/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.ide.eclipse.beans.core.internal.model.AbstractBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.ObjectUtils;

public class BeanReference
extends AbstractBeansModelElement
implements IBeanReference {
    private String beanName;

    public BeanReference(ISourceModelElement parent, org.springframework.beans.factory.config.BeanReference beanRef) {
        super((IModelElement)parent, "(bean reference)", (BeanMetadataElement)beanRef);
        this.beanName = beanRef.getBeanName();
    }

    public int getElementType() {
        return 11;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BeanReference)) {
            return false;
        }
        BeanReference that = (BeanReference)other;
        if (!ObjectUtils.nullSafeEquals((Object)this.beanName, (Object)that.beanName)) {
            return false;
        }
        return super.equals(other);
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.beanName);
        return this.getElementType() * hashCode + super.hashCode();
    }

    public String toString() {
        StringBuffer text = new StringBuffer(super.toString());
        text.append(": name=");
        text.append(this.beanName);
        return text.toString();
    }
}

