/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class FileMatchPattern
implements Cloneable {
    private boolean mIsIncludePattern = true;
    private Pattern mRegexPattern;
    private String mPatternString;

    public FileMatchPattern(String pattern) throws CheckstylePluginException {
        this.setMatchPattern(pattern);
    }

    public String getMatchPattern() {
        return this.mRegexPattern.pattern();
    }

    public void setMatchPattern(String pattern) throws CheckstylePluginException {
        if (pattern == null || pattern.trim().length() == 0) {
            throw new CheckstylePluginException(Messages.errorEmptyPattern);
        }
        try {
            this.mRegexPattern = Pattern.compile(pattern);
            this.mPatternString = pattern;
        }
        catch (PatternSyntaxException e) {
            CheckstylePluginException.rethrow(e);
        }
    }

    public boolean isMatch(String fileName) {
        boolean result = false;
        Matcher matcher = this.mRegexPattern.matcher(fileName);
        result = matcher.find();
        return result;
    }

    public boolean isIncludePattern() {
        return this.mIsIncludePattern;
    }

    public void setIsIncludePattern(boolean isIncludePattern) {
        this.mIsIncludePattern = isIncludePattern;
    }

    public FileMatchPattern clone() {
        try {
            return (FileMatchPattern)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FileMatchPattern)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FileMatchPattern rhs = (FileMatchPattern)obj;
        return new EqualsBuilder().append(this.mIsIncludePattern, rhs.mIsIncludePattern).append((Object)this.mPatternString, (Object)rhs.mPatternString).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7687, 1000003).append(this.mIsIncludePattern).append((Object)this.mPatternString).toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

