/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AvatarStore
implements Serializable,
ISchedulingRule {
    private static final long serialVersionUID = -7791322302733784441L;
    public static final int TIMEOUT = 30000;
    public static final int BUFFER_SIZE = 8192;
    private Map<String, byte[]> avatars = new HashMap<String, byte[]>();

    public ImageData getAvatar(String url) {
        byte[] cached;
        ImageData data = null;
        if ((url = this.normalize(url)) != null && (cached = this.avatars.get(url)) != null) {
            data = this.getData(cached);
        }
        return data;
    }

    protected String normalize(String url) {
        try {
            URL parsed = new URL(url);
            parsed = new URL(parsed.getProtocol(), parsed.getHost(), parsed.getPath());
            return parsed.toExternalForm();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void loadAvatar(final String url, final IAvatarCallback callback) {
        Job job = new Job(MessageFormat.format("Loading avatar for {0}", url)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ImageData data = AvatarStore.this.loadAvatar(url);
                    if (data != null) {
                        callback.loaded(data, AvatarStore.this);
                    }
                }
                catch (IOException iOException) {}
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public ImageData loadAvatar(String url) throws IOException {
        url = this.normalize(url);
        URL parsed = new URL(url);
        byte[] data = this.avatars.get(url);
        if (data != null) {
            return this.getData(data);
        }
        URLConnection connection = parsed.openConnection();
        connection.setConnectTimeout(30000);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        InputStream input = connection.getInputStream();
        try {
            byte[] buffer = new byte[8192];
            int read = input.read(buffer);
            while (read != -1) {
                output.write(buffer, 0, read);
                read = input.read(buffer);
            }
        }
        catch (Throwable throwable) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
            try {
                output.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            input.close();
        }
        catch (IOException iOException) {}
        try {
            output.close();
        }
        catch (IOException iOException) {}
        data = output.toByteArray();
        this.avatars.put(url, data);
        return this.getData(data);
    }

    public Image getScaledImage(int size, ImageData data) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Image image = new Image((Device)display, data);
        Rectangle sourceBounds = image.getBounds();
        if (sourceBounds.width == size) {
            return image;
        }
        Image scaled = new Image((Device)display, size, size);
        GC gc = new GC((Drawable)scaled);
        try {
            gc.setAntialias(1);
            gc.setInterpolation(2);
            Rectangle targetBounds = scaled.getBounds();
            gc.drawImage(image, 0, 0, sourceBounds.width, sourceBounds.height, 0, 0, targetBounds.width, targetBounds.height);
        }
        finally {
            gc.dispose();
            image.dispose();
        }
        return scaled;
    }

    public ImageData getData(byte[] bytes) {
        ByteArrayInputStream stream;
        block8: {
            ImageData imageData;
            stream = new ByteArrayInputStream(bytes);
            try {
                ImageData[] images = new ImageLoader().load((InputStream)stream);
                if (images.length <= 0) break block8;
                imageData = images[0];
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            return imageData;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    public boolean contains(ISchedulingRule rule) {
        return this == rule;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this == rule;
    }

    public static interface IAvatarCallback {
        public void loaded(ImageData var1, AvatarStore var2);
    }
}

