/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ajdt.ui.xref;

import org.eclipse.contribution.xref.core.IXReferenceNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.springframework.ide.eclipse.ajdt.ui.xref.AopReferenceModelNodeAdapter;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.util.AopReferenceModelUtils;
import org.springframework.util.ObjectUtils;

public class AopReferenceModelNode
implements IAdaptable,
IXReferenceNode {
    private String label;
    private IAopReference reference;
    private TYPE type;

    public AopReferenceModelNode(TYPE type, IAopReference reference) {
        this.reference = reference;
        this.type = type;
        this.computeLabel();
    }

    private void computeLabel() {
        this.label = this.getJavaElement() != null ? (this.getJavaElement() instanceof IMethod ? String.valueOf(this.getJavaElement().getParent().getElementName()) + '.' + AopReferenceModelUtils.readableName((IMethod)((IMethod)this.getJavaElement())) : this.getJavaElement().getElementName()) : this.reference.getDefinition().getAspectName();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return AopReferenceModelNodeAdapter.getDefault();
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public IJavaElement getJavaElement() {
        if (this.type.equals((Object)TYPE.SOURCE)) {
            return this.reference.getSource();
        }
        if (this.type.equals((Object)TYPE.TARGET)) {
            return this.reference.getTarget();
        }
        return null;
    }

    public IAspectDefinition getDefinition() {
        return this.reference.getDefinition();
    }

    public IResource getResouce() {
        return this.reference.getResource();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AopReferenceModelNode) {
            AopReferenceModelNode other = (AopReferenceModelNode)obj;
            return this.getLabel().equals(other.getLabel());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = ObjectUtils.nullSafeHashCode((Object)this.getLabel());
        return hashCode;
    }

    public static enum TYPE {
        SOURCE,
        TARGET;

    }
}

