/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.autowire.internal.provider;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ide.eclipse.beans.core.autowire.IAutowireDependencyResolver;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProvider;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.IInjectionMetadataProviderProblemReporter;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.InjectionMetadata;
import org.springframework.ide.eclipse.beans.core.autowire.internal.provider.PassThroughProblemReporter;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class AutowiredAnnotationInjectionMetadataProvider
implements IInjectionMetadataProvider {
    private final Set<Class<? extends Annotation>> autowiredAnnotationTypes = new LinkedHashSet<Class<? extends Annotation>>();
    private String requiredParameterName = "required";
    private boolean requiredParameterValue = true;
    private final Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();
    private IInjectionMetadataProviderProblemReporter problemReporter = new PassThroughProblemReporter();

    public AutowiredAnnotationInjectionMetadataProvider(ClassLoader cl) {
        try {
            this.autowiredAnnotationTypes.add(cl.loadClass(Autowired.class.getName()));
            this.autowiredAnnotationTypes.add(cl.loadClass(Value.class.getName()));
            this.autowiredAnnotationTypes.add(cl.loadClass("javax.inject.Inject"));
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    public void setProblemReporter(IInjectionMetadataProviderProblemReporter problemReporter) {
        this.problemReporter = problemReporter;
    }

    public void setAutowiredAnnotationType(Class<? extends Annotation> autowiredAnnotationType) {
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.add(autowiredAnnotationType);
    }

    public void setAutowiredAnnotationTypes(Set<Class<? extends Annotation>> autowiredAnnotationTypes) {
        this.autowiredAnnotationTypes.clear();
        this.autowiredAnnotationTypes.addAll(autowiredAnnotationTypes);
    }

    public void setRequiredParameterName(String requiredParameterName) {
        this.requiredParameterName = requiredParameterName;
    }

    public void setRequiredParameterValue(boolean requiredParameterValue) {
        this.requiredParameterValue = requiredParameterValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InjectionMetadata findAutowiringMetadata(final Class<?> clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    final InjectionMetadata newMetadata = new InjectionMetadata();
                    ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) {
                            Annotation annotation = AutowiredAnnotationInjectionMetadataProvider.this.findAutowiredAnnotation(field);
                            if (annotation != null) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    AutowiredAnnotationInjectionMetadataProvider.this.problemReporter.error("@Autowired annotation is not supported on static fields", field, new ValidationProblemAttribute[0]);
                                    return;
                                }
                                boolean required = AutowiredAnnotationInjectionMetadataProvider.this.determineRequiredStatus(annotation);
                                newMetadata.addInjectedField(new AutowiredFieldElement(field, required));
                            }
                        }
                    });
                    ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) {
                            Annotation annotation = AutowiredAnnotationInjectionMetadataProvider.this.findAutowiredAnnotation(method);
                            if (annotation != null && method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) {
                                boolean error = false;
                                if (Modifier.isStatic(method.getModifiers())) {
                                    AutowiredAnnotationInjectionMetadataProvider.this.problemReporter.error("@Autowired annotation is not supported on static methods", method, new ValidationProblemAttribute[0]);
                                    error = true;
                                }
                                if (method.getParameterTypes().length == 0) {
                                    AutowiredAnnotationInjectionMetadataProvider.this.problemReporter.error("@Autowired annotation requires at least one argument", method, new ValidationProblemAttribute[0]);
                                    error = true;
                                }
                                if (!error) {
                                    boolean required = AutowiredAnnotationInjectionMetadataProvider.this.determineRequiredStatus(annotation);
                                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                                    newMetadata.addInjectedMethod(new AutowiredMethodElement(clazz, method, required, pd));
                                }
                            }
                        }
                    });
                    Constructor<?>[] rawCandidates = clazz.getDeclaredConstructors();
                    ArrayList candidates = new ArrayList(rawCandidates.length);
                    Constructor<?> requiredConstructor = null;
                    Constructor<?>[] constructorArray = rawCandidates;
                    int n = rawCandidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constructor<?> candidate = constructorArray[n2];
                        Annotation annotation = this.findAutowiredAnnotation(candidate);
                        if (annotation != null) {
                            if (requiredConstructor != null) {
                                this.problemReporter.error("Invalid @Autowire-marked constructor", candidate, new ValidationProblemAttribute[0]);
                                this.problemReporter.error("Found another constructor with 'required' @Autowired annotation", requiredConstructor, new ValidationProblemAttribute[0]);
                                break;
                            }
                            if (candidate.getParameterTypes().length == 0) {
                                this.problemReporter.error("@Autowired annotation requires at least one argument", candidate, new ValidationProblemAttribute[0]);
                                break;
                            }
                            boolean required = this.determineRequiredStatus(annotation);
                            if (required) {
                                if (!candidates.isEmpty()) {
                                    for (Constructor constructor : candidates) {
                                        this.problemReporter.error("Invalid @Autowire-marked constructor", constructor, new ValidationProblemAttribute[0]);
                                    }
                                    this.problemReporter.error("Found another constructor with 'required' @Autowired annotation", requiredConstructor, new ValidationProblemAttribute[0]);
                                    break;
                                }
                                requiredConstructor = candidate;
                            }
                            newMetadata.addInjectedConstructor(new AutowiredConstructorElement(clazz, candidate, required));
                            candidates.add(candidate);
                        }
                        ++n2;
                    }
                    metadata = newMetadata;
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    private Annotation findAutowiredAnnotation(AccessibleObject ao) {
        for (Class<? extends Annotation> type : this.autowiredAnnotationTypes) {
            Annotation annotation = ao.getAnnotation(type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    protected boolean determineRequiredStatus(Annotation annotation) {
        try {
            Method method = ReflectionUtils.findMethod(annotation.annotationType(), (String)this.requiredParameterName);
            return this.requiredParameterValue == (Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)annotation);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private class AutowiredConstructorElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private final Class<?> beanClass;

        public AutowiredConstructorElement(Class<?> beanClass, Constructor<?> ctor, boolean required) {
            super(ctor, null);
            this.required = required;
            this.beanClass = beanClass;
        }

        @Override
        public DependencyDescriptor[] getDependencyDescriptor(IAutowireDependencyResolver resolver) {
            Constructor method = (Constructor)this.member;
            Class<?>[] paramTypes = method.getParameterTypes();
            DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes.length];
            int i = 0;
            while (i < paramTypes.length) {
                MethodParameter methodParam = new MethodParameter(method, i);
                GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, this.beanClass);
                descriptors[i] = new DependencyDescriptor(methodParam, this.required);
                ++i;
            }
            return descriptors;
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;

        public AutowiredFieldElement(Field field, boolean required) {
            super(field, null);
            this.required = required;
        }

        @Override
        protected DependencyDescriptor[] getDependencyDescriptor(IAutowireDependencyResolver resolver) {
            return new DependencyDescriptor[]{new DependencyDescriptor((Field)this.getMember(), this.required)};
        }
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final boolean required;
        private final Class<?> beanClass;

        public AutowiredMethodElement(Class<?> beanClass, Method method, boolean required, PropertyDescriptor pd) {
            super(method, pd);
            this.required = required;
            this.beanClass = beanClass;
        }

        @Override
        public DependencyDescriptor[] getDependencyDescriptor(IAutowireDependencyResolver resolver) {
            Method method = (Method)this.member;
            Class<?>[] paramTypes = method.getParameterTypes();
            DependencyDescriptor[] descriptors = new DependencyDescriptor[paramTypes.length];
            int i = 0;
            while (i < paramTypes.length) {
                MethodParameter methodParam = new MethodParameter(method, i);
                GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, this.beanClass);
                descriptors[i] = new DependencyDescriptor(methodParam, this.required);
                ++i;
            }
            return descriptors;
        }

        @Override
        public boolean shouldSkip(BeanDefinition bd) {
            return this.checkPropertySkipping((PropertyValues)bd.getPropertyValues());
        }
    }
}

