/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.FolderSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.testng.eclipse.TestNGPlugin;
import org.testng.eclipse.ui.util.Utils;
import org.testng.eclipse.util.JDTUtil;
import org.testng.eclipse.util.PreferenceStoreUtil;
import org.testng.eclipse.util.ResourceUtil;
import org.testng.eclipse.util.SWTUtil;

public class ProjectPropertyPage
extends PropertyPage {
    private Text m_outputdir;
    private Button m_absolutePath;
    private Button m_disabledDefaultListeners;
    private Text m_xmlTemplateFile;
    private Text m_preDefinedListeners;
    private IProject m_workingProject;
    private Button m_projectJar;
    private Text m_watchResultText;
    private Button m_watchResultRadio;

    public void createControl(Composite parent) {
        this.setDescription("Project TestNG settings");
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite parentComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(parentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parentComposite);
        Group g = new Group(parentComposite, 16);
        g.setLayout((Layout)new GridLayout());
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DirectoryDialog dlg = new DirectoryDialog(ProjectPropertyPage.this.m_outputdir.getShell());
                dlg.setMessage("Select TestNG output directory");
                String selectedDir = dlg.open();
                ProjectPropertyPage.this.m_outputdir.setText(selectedDir != null ? selectedDir : "");
                ProjectPropertyPage.this.m_absolutePath.setSelection(true);
            }
        };
        Utils.Widgets w = Utils.createTextBrowseControl((Composite)g, null, "TestNGPropertyPage.outputDir", (SelectionListener)buttonListener, null, null, true);
        this.m_outputdir = w.text;
        this.m_absolutePath = new Button((Composite)g, 32);
        this.m_absolutePath.setText("Absolute output path");
        this.m_absolutePath.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        g.setLayoutData((Object)SWTUtil.createGridData());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                DirectoryDialog dlg = new DirectoryDialog(ProjectPropertyPage.this.m_xmlTemplateFile.getShell());
                dlg.setMessage("Select TestNG Output Directory");
                String selectedDir = dlg.open();
                if (new File(selectedDir).isDirectory()) {
                    selectedDir = String.valueOf(selectedDir) + File.separator + "testng-results.xml";
                }
                ProjectPropertyPage.this.m_watchResultText.setText(selectedDir != null ? selectedDir : "");
            }
        };
        Utils.Widgets w2 = Utils.createTextBrowseControl(parentComposite, "TestNGPropertyPage.watchResultXml", "TestNGPropertyPage.resultXmlDirectory", (SelectionListener)listener, null, null, true);
        this.m_watchResultText = w2.text;
        this.m_watchResultRadio = w2.radio;
        SelectionAdapter buttonListener2 = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dlg = new FileDialog(ProjectPropertyPage.this.m_xmlTemplateFile.getShell());
                dlg.setText("Select Template XML file");
                String[] filterExt = new String[]{"*.xml"};
                dlg.setFilterExtensions(filterExt);
                String selectedFile = dlg.open();
                ProjectPropertyPage.this.m_xmlTemplateFile.setText(selectedFile != null ? selectedFile : "");
            }
        };
        w2 = Utils.createTextBrowseControl(parentComposite, null, "TestNGPropertyPage.templateXml", (SelectionListener)buttonListener2, null, null, true);
        this.m_xmlTemplateFile = w2.text;
        this.m_disabledDefaultListeners = new Button(parentComposite, 32);
        this.m_disabledDefaultListeners.setText("Disable default listeners");
        this.m_projectJar = new Button(parentComposite, 32);
        this.m_projectJar.setText(ResourceUtil.getString("TestNGPropertyPage.useProjectTestNGJar"));
        Utils.Widgets w3 = Utils.createStringEditorControl(parentComposite, "TestNGPropertyPage.preDefinedListeners", null, true);
        this.m_preDefinedListeners = w3.text;
        this.m_preDefinedListeners.setToolTipText("Split multi listener using ;");
        this.loadDefaults();
        return parentComposite;
    }

    public void dispose() {
        this.m_projectJar.dispose();
        this.m_outputdir.dispose();
        this.m_absolutePath.dispose();
        this.m_disabledDefaultListeners.dispose();
        this.m_xmlTemplateFile.dispose();
        this.m_preDefinedListeners.dispose();
        super.dispose();
    }

    private void loadDefaults() {
        this.m_workingProject = (IProject)this.getElement().getAdapter(IProject.class);
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        String projectName = this.m_workingProject.getName();
        this.m_outputdir.setText(storage.getOutputDir(projectName, true));
        this.m_absolutePath.setSelection(storage.isOutputAbsolutePath(projectName, true));
        this.m_disabledDefaultListeners.setSelection(storage.hasDisabledListeners(projectName, true));
        this.m_xmlTemplateFile.setText(storage.getXmlTemplateFile(projectName, true));
        this.m_projectJar.setSelection(storage.getUseProjectJar(projectName));
        this.m_watchResultRadio.setSelection(storage.getWatchResults(projectName));
        String dir = storage.getWatchResultDirectory(projectName);
        this.m_watchResultText.setText(dir);
        this.m_preDefinedListeners.setText(storage.getPreDefinedListeners(projectName, false));
    }

    protected void performDefaults() {
        this.loadDefaults();
        super.performDefaults();
    }

    public boolean performOk() {
        PreferenceStoreUtil storage = TestNGPlugin.getPluginPreferenceStore();
        String projectName = this.m_workingProject.getName();
        storage.storeOutputDir(projectName, this.m_outputdir.getText(), this.m_absolutePath.getSelection());
        storage.storeDisabledListeners(projectName, this.m_disabledDefaultListeners.getSelection());
        storage.storeXmlTemplateFile(projectName, this.m_xmlTemplateFile.getText());
        storage.storePreDefinedListeners(projectName, this.m_preDefinedListeners.getText());
        storage.storeUseProjectJar(projectName, this.m_projectJar.getSelection());
        storage.storeWatchResults(projectName, this.m_watchResultRadio.getSelection());
        storage.storeWatchResultLocation(projectName, this.m_watchResultText.getText());
        if (super.performOk()) {
            this.setMessage("Project preferences are saved", 1);
            return true;
        }
        return false;
    }

    private void handleBrowseAction() {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0) {
                    return new StatusInfo(4, "empty selection is not allowed");
                }
                if (selection.length > 1) {
                    return new StatusInfo(4, "multiple selection is not allowed");
                }
                if (IFolder.class.isInstance(selection[0]) || IProject.class.isInstance(selection[0])) {
                    return new StatusInfo();
                }
                return new StatusInfo(4, "not accepted type");
            }
        };
        IWorkspaceRoot workspaceRoot = JDTUtil.getWorkspaceRoot();
        IProject[] allProjects = workspaceRoot.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.m_workingProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        ProjectContentProvider cp = new ProjectContentProvider();
        Object initSelection = null;
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle("Select TestNG output artifacts directory");
        dialog.setValidator(validator);
        dialog.setMessage("a message");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)workspaceRoot);
        dialog.setInitialSelection(initSelection);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            this.m_outputdir.setText(((IContainer)dialog.getFirstResult()).getProjectRelativePath().toPortableString());
            this.m_absolutePath.setSelection(false);
        }
    }

    public static class ProjectContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IContainer) {
                try {
                    return ((IContainer)parentElement).members();
                }
                catch (CoreException coreException) {}
            }
            return null;
        }

        public Object getParent(Object element) {
            return ((IResource)element).getParent();
        }

        public boolean hasChildren(Object element) {
            IResource resource = (IResource)element;
            return 1 != resource.getType();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

