/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.ISVNCommand;
import org.tigris.subversion.subclipse.core.resources.RemoteFile;
import org.tigris.subversion.subclipse.core.resources.RemoteFolder;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class GetRemoteResourceCommand
implements ISVNCommand {
    private ISVNRepositoryLocation repository;
    private SVNUrl url;
    private SVNRevision revision;
    private ISVNRemoteResource remoteResource;

    public GetRemoteResourceCommand(ISVNRepositoryLocation repository, SVNUrl url, SVNRevision revision) {
        this.repository = repository;
        this.url = url;
        this.revision = revision;
    }

    public void run(IProgressMonitor monitor) throws SVNException {
        ISVNInfo info;
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(Policy.bind("GetRemoteResourceCommand.getLogEntries"), 100);
        this.remoteResource = null;
        ISVNClientAdapter svnClient = this.repository.getSVNClient();
        try {
            try {
                info = svnClient.getInfo(this.url, this.revision, this.revision);
            }
            catch (SVNClientException e) {
                throw new SVNException("Can't get remote resource " + this.url + " at revision " + this.revision, e);
            }
        }
        finally {
            this.repository.returnSVNClient(svnClient);
        }
        this.remoteResource = info == null ? null : (info.getNodeKind() == SVNNodeKind.FILE ? new RemoteFile(null, this.repository, this.url, this.revision, info.getLastChangedRevision(), info.getLastChangedDate(), info.getLastCommitAuthor()) : new RemoteFolder(null, this.repository, this.url, this.revision, info.getLastChangedRevision(), info.getLastChangedDate(), info.getLastCommitAuthor()));
        monitor.done();
    }

    public ISVNRemoteResource getRemoteResource() {
        return this.remoteResource;
    }
}

