/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public abstract class FieldModel<T> {
    private Class<T> type;
    private String name;
    private String label;
    private LiveVariable<T> variable;
    private LiveExpression<ValidationResult> validator;

    public FieldModel(Class<T> type, String name, T defaultValue) {
        this.type = type;
        this.name = name;
        this.label = name;
        this.variable = new LiveVariable<T>(defaultValue);
        this.validator = Validator.OK;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    public FieldModel<T> label(String l) {
        this.label = l;
        return this;
    }

    public FieldModel<T> validator(LiveExpression<ValidationResult> v) {
        this.validator = v;
        return this;
    }

    public void setValue(T v) {
        this.variable.setValue(v);
    }

    public T getValue() {
        return (T)this.variable.getValue();
    }

    public LiveVariable<T> getVariable() {
        return this.variable;
    }
}

