/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SpringCoreUtils {
    public static String BUNDLE_MANIFEST_FILE = "MANIFEST.MF";
    public static String BUNDLE_MANIFEST_FOLDER = "META-INF";
    public static final String EL_PLACEHOLDER_PREFIX = "#{";
    public static final String FILE_SCHEME = "file";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    public static final String SOURCE_CONTROL_SCHEME = "sourcecontrol";
    private static final String DEPLOY_PATH = "deploy-path";
    private static boolean DOCUMENT_BUILDER_ERROR = false;
    private static final Object DOCUMENT_BUILDER_LOCK = new Object();
    private static XPathExpression EXPRESSION;
    private static boolean SAX_PARSER_ERROR;
    private static final Object SAX_PARSER_LOCK;
    private static final String SOURCE_PATH = "source-path";
    private static final String XPATH_EXPRESSION = "//project-modules/wb-module/wb-resource";

    static {
        SAX_PARSER_ERROR = false;
        SAX_PARSER_LOCK = new Object();
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            EXPRESSION = xpath.compile(XPATH_EXPRESSION);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addProjectBuilder(IProject project, String builderID, IProgressMonitor monitor) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand builderCommand = SpringCoreUtils.getProjectBuilderCommand(desc, builderID);
        if (builderCommand == null) {
            ICommand command = desc.newCommand();
            command.setBuilderName(builderID);
            SpringCoreUtils.addProjectBuilderCommand(desc, command);
            project.setDescription(desc, monitor);
        }
    }

    public static void addProjectBuilderCommand(IProjectDescription description, ICommand command) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldBuilderCommand = SpringCoreUtils.getProjectBuilderCommand(description, command.getBuilderName());
        if (oldBuilderCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 0, oldCommands.length);
            newCommands[oldCommands.length] = command;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldBuilderCommand) {
                    oldCommands[i] = command;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
    }

    public static void addProjectNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (project != null && nature != null && !project.hasNature(nature)) {
            IProjectDescription desc = project.getDescription();
            String[] oldNatures = desc.getNatureIds();
            String[] newNatures = new String[oldNatures.length + 1];
            newNatures[0] = nature;
            if (oldNatures.length > 0) {
                System.arraycopy(oldNatures, 0, newNatures, 1, oldNatures.length);
            }
            desc.setNatureIds(newNatures);
            project.setDescription(desc, monitor);
        }
    }

    public static void buildProject(IProject project) {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            SpringCoreUtils.scheduleBuildInBackground(project, ResourcesPlugin.getWorkspace().getRuleFactory().buildRule(), new Object[]{ResourcesPlugin.FAMILY_AUTO_BUILD}, true);
        }
    }

    public static void buildFullProject(IProject project) {
        if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            SpringCoreUtils.scheduleBuildInBackground(project, ResourcesPlugin.getWorkspace().getRuleFactory().buildRule(), new Object[]{ResourcesPlugin.FAMILY_AUTO_BUILD}, false);
        }
    }

    public static void createFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                SpringCoreUtils.createFolder((IFolder)parent, monitor);
            }
            folder.create(true, true, monitor);
        }
    }

    public static IProject createProject(String projectName, IProjectDescription description, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (!project.exists()) {
            if (description == null) {
                project.create(monitor);
            } else {
                project.create(description, monitor);
            }
        } else {
            project.refreshLocal(2, monitor);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.isOpen()) {
            project.open(monitor);
        }
        return project;
    }

    public static String findLineSeparator(char[] text) {
        int length = text.length;
        if (length > 0) {
            int nextChar = text[0];
            int i = 0;
            while (i < length) {
                int currentChar = nextChar;
                nextChar = i < length - 1 ? text[i + 1] : 32;
                switch (currentChar) {
                    case 10: {
                        return "\n";
                    }
                    case 13: {
                        return nextChar == 10 ? "\r\n" : "\r";
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public static <T> T getAdapter(Object object, Class<T> adapter) {
        if (object != null && adapter != null) {
            if (adapter.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            if (object instanceof IAdaptable) {
                return (T)((IAdaptable)object).getAdapter(adapter);
            }
        }
        return null;
    }

    public static IFile getDeploymentDescriptor(IProject project) {
        IFile settingsFile;
        if (SpringCoreUtils.hasProjectFacet((IResource)project, "jst.web") && (settingsFile = project.getFile(".settings/org.eclipse.wst.common.component")).exists()) {
            try {
                NodeList nodes = (NodeList)EXPRESSION.evaluate(SpringCoreUtils.parseDocument(settingsFile), XPathConstants.NODESET);
                int i = 0;
                while (i < nodes.getLength()) {
                    IFile deploymentDescriptor;
                    String path;
                    Element element = (Element)nodes.item(i);
                    if ("/".equals(element.getAttribute(DEPLOY_PATH)) && (path = element.getAttribute(SOURCE_PATH)) != null && (deploymentDescriptor = project.getFile(new Path(path).append("WEB-INF").append("web.xml"))).exists()) {
                        return deploymentDescriptor;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                SpringCore.log((IStatus)new Status(2, "org.springframework.ide.eclipse.core", 1, e.getMessage(), (Throwable)e));
            }
        }
        return null;
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return SpringCoreUtils.getDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception e) {
            SpringCore.log(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        BundleContext bundleContext;
        ServiceReference reference;
        if (!DOCUMENT_BUILDER_ERROR) {
            try {
                return DocumentBuilderFactory.newInstance();
            }
            catch (Exception exception) {
                SpringCore.log((IStatus)new Status(1, "org.springframework.ide.eclipse.core", "Error creating DocumentBuilderFactory. Switching to OSGi service reference."));
                DOCUMENT_BUILDER_ERROR = true;
            }
        }
        if ((reference = (bundleContext = SpringCore.getDefault().getBundle().getBundleContext()).getServiceReference(DocumentBuilderFactory.class.getName())) != null) {
            try {
                Object object = DOCUMENT_BUILDER_LOCK;
                synchronized (object) {
                    try {
                        DocumentBuilderFactory documentBuilderFactory = (DocumentBuilderFactory)bundleContext.getService(reference);
                        return documentBuilderFactory;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            SpringCore.log(e);
                        }
                    }
                }
            }
            finally {
                bundleContext.ungetService(reference);
            }
        }
        {
            return null;
        }
    }

    public static String getLineSeparator(String text, IProject project) {
        IScopeContext[] scopeContext;
        String lineSeparator = null;
        if (text != null && text.length() != 0 && (lineSeparator = SpringCoreUtils.findLineSeparator(text.toCharArray())) != null) {
            return lineSeparator;
        }
        if (project != null) {
            scopeContext = new IScopeContext[]{new ProjectScope(project)};
            lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
            if (lineSeparator != null) {
                return lineSeparator;
            }
        }
        scopeContext = new IScopeContext[]{new InstanceScope()};
        lineSeparator = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", null, scopeContext);
        if (lineSeparator != null) {
            return lineSeparator;
        }
        return LINE_SEPARATOR;
    }

    public static ICommand getProjectBuilderCommand(IProjectDescription description, String builderID) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = commands.length - 1;
        while (i >= 0) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            --i;
        }
        return null;
    }

    public static IPath getProjectLocation(IProject project) {
        return project.getRawLocation() != null ? project.getRawLocation() : project.getLocation();
    }

    public static URI getResourceURI(IResource resource) {
        if (resource != null) {
            URI uri = resource.getRawLocationURI();
            if (uri == null) {
                uri = resource.getLocationURI();
            }
            if (uri != null) {
                String scheme = uri.getScheme();
                if (FILE_SCHEME.equalsIgnoreCase(scheme)) {
                    return uri;
                }
                if (SOURCE_CONTROL_SCHEME.equals(scheme)) {
                    IPath path = resource.getLocation();
                    File file = path.toFile();
                    if (file.exists()) {
                        return file.toURI();
                    }
                } else {
                    IPathVariableManager variableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
                    return variableManager.resolveURI(uri);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParser getSaxParser() {
        BundleContext bundleContext;
        ServiceReference reference;
        if (!SAX_PARSER_ERROR) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                SAXParser parser = factory.newSAXParser();
                return parser;
            }
            catch (Exception exception) {
                SpringCore.log((IStatus)new Status(1, "org.springframework.ide.eclipse.core", "Error creating SaxParserFactory. Switching to OSGI service reference."));
                SAX_PARSER_ERROR = true;
            }
        }
        if ((reference = (bundleContext = SpringCore.getDefault().getBundle().getBundleContext()).getServiceReference(SAXParserFactory.class.getName())) != null) {
            try {
                Object object = SAX_PARSER_LOCK;
                synchronized (object) {
                    try {
                        SAXParserFactory factory = (SAXParserFactory)bundleContext.getService(reference);
                        SAXParser sAXParser = factory.newSAXParser();
                        return sAXParser;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (Exception e) {
                            SpringCore.log(e);
                        }
                    }
                }
            }
            finally {
                bundleContext.ungetService(reference);
            }
        }
        {
            return null;
        }
    }

    public static Set<IProject> getSpringProjects() {
        LinkedHashSet<IProject> projects = new LinkedHashSet<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (SpringCoreUtils.isSpringProject((IResource)project)) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    public static boolean hasNature(IResource resource, String natureId) {
        IProject project;
        if (resource != null && resource.isAccessible() && (project = resource.getProject()) != null) {
            try {
                return project.hasNature(natureId);
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return false;
    }

    public static boolean hasPlaceHolder(String text) {
        if (text == null || !StringUtils.hasText((String)text)) {
            return false;
        }
        int pos = text.indexOf(PLACEHOLDER_PREFIX);
        int elPos = text.indexOf(EL_PLACEHOLDER_PREFIX);
        return (pos != -1 || elPos != -1) && text.indexOf(PLACEHOLDER_SUFFIX, pos) != -1;
    }

    public static boolean hasProjectFacet(IResource resource, String facetId) {
        if (resource != null && resource.isAccessible()) {
            try {
                return JdtUtils.isJavaProject(resource) && FacetedProjectFramework.hasProjectFacet((IProject)resource.getProject(), (String)facetId);
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public static boolean isEclipseSameOrNewer(int majorVersion, int minorVersion) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        if (bundle != null) {
            int minor;
            int major;
            Version version;
            block5: {
                String versionString = (String)bundle.getHeaders().get("Bundle-Version");
                try {
                    version = new Version(versionString);
                    major = version.getMajor();
                    if (major <= majorVersion) break block5;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (major == majorVersion && (minor = version.getMinor()) >= minorVersion) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isManifest(IResource resource) {
        if (resource == null) return false;
        if (resource.getType() != 1) return false;
        if (!resource.getName().equals(BUNDLE_MANIFEST_FILE)) return false;
        if (resource.getParent() == null) return false;
        if (resource.getParent().getProjectRelativePath() == null) return false;
        if (resource.getParent().getProjectRelativePath().lastSegment() == null) return false;
        if (!resource.getParent().getProjectRelativePath().lastSegment().equals(BUNDLE_MANIFEST_FOLDER)) return false;
        IPath filePath = resource.getFullPath();
        IJavaProject javaProject = JdtUtils.getJavaProject(resource);
        if (javaProject == null) return true;
        try {
            IPath defaultOutputLocation = javaProject.getOutputLocation();
            if (defaultOutputLocation != null && defaultOutputLocation.isPrefixOf(filePath)) {
                return false;
            }
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                IPath outputLocation;
                if (n2 >= n) {
                    return true;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3 && (outputLocation = entry.getOutputLocation()) != null && outputLocation.isPrefixOf(filePath)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return true;
    }

    public static boolean isSpringProject(IResource resource) {
        return SpringCoreUtils.hasNature(resource, "org.springframework.ide.eclipse.core.springnature");
    }

    public static boolean isVersionSameOrNewer(String versionString, int majorVersion, int minorVersion, int microVersion) {
        return new Version(versionString).compareTo(new Version(majorVersion, minorVersion, microVersion)) >= 0;
    }

    public static Document parseDocument(IFile deploymentDescriptor) {
        try {
            if (SpringCoreUtils.getResourceURI((IResource)deploymentDescriptor) != null) {
                return SpringCoreUtils.parseDocument(SpringCoreUtils.getResourceURI((IResource)deploymentDescriptor));
            }
            return SpringCoreUtils.getDocumentBuilder().parse(new InputSource(deploymentDescriptor.getContents()));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document parseDocument(URI deploymentDescriptor) {
        try {
            return SpringCoreUtils.getDocumentBuilder().parse(deploymentDescriptor.toString());
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeProjectBuilder(IProject project, String builderID, IProgressMonitor monitor) throws CoreException {
        if (project != null && builderID != null) {
            IProjectDescription desc = project.getDescription();
            ICommand[] commands = desc.getBuildSpec();
            int i = commands.length - 1;
            while (i >= 0) {
                if (commands[i].getBuilderName().equals(builderID)) {
                    ICommand[] newCommands = new ICommand[commands.length - 1];
                    System.arraycopy(commands, 0, newCommands, 0, i);
                    System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                    desc.setBuildSpec(newCommands);
                    project.setDescription(desc, monitor);
                    break;
                }
                --i;
            }
        }
    }

    public static void removeProjectNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (project != null && nature != null && project.exists() && project.hasNature(nature)) {
            if (nature.equals("org.springframework.ide.eclipse.core.springnature")) {
                project.deleteMarkers("org.springframework.ide.eclipse.core.problemmarker", true, 2);
            }
            IProjectDescription desc = project.getDescription();
            String[] oldNatures = desc.getNatureIds();
            String[] newNatures = new String[oldNatures.length - 1];
            int newIndex = oldNatures.length - 2;
            int i = oldNatures.length - 1;
            while (i >= 0) {
                if (!oldNatures[i].equals(nature)) {
                    newNatures[newIndex--] = oldNatures[i];
                }
                --i;
            }
            desc.setNatureIds(newNatures);
            project.setDescription(desc, monitor);
        }
    }

    public static boolean validateEdit(IFile ... files) {
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (!file.exists()) {
                return false;
            }
            ++n2;
        }
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(files, IWorkspace.VALIDATE_PROMPT);
        return status.isOK();
    }

    private static void scheduleBuildInBackground(final IProject project, ISchedulingRule rule, final Object[] jobFamilies, final boolean springBuilderOnly) {
        Job job = new Job("Building workspace"){

            public boolean belongsTo(Object family) {
                if (jobFamilies == null || family == null) {
                    return false;
                }
                int i = 0;
                while (i < jobFamilies.length) {
                    if (family.equals(jobFamilies[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            public IStatus run(IProgressMonitor monitor) {
                try {
                    if (springBuilderOnly) {
                        project.build(6, "org.springframework.ide.eclipse.core.springbuilder", null, monitor);
                    } else {
                        project.build(6, monitor);
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return new Status(4, "org.springframework.ide.eclipse.core", 1, "Error during build of project [" + project.getName() + "]", (Throwable)e);
                }
            }
        };
        if (rule != null) {
            job.setRule(rule);
        }
        job.setPriority(40);
        job.schedule();
    }
}

