/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.extensions.PageAdaptersExtensionPointConstants;
import org.springframework.ide.eclipse.config.ui.editors.AbstractConfigFormPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SpringConfigContentProvider
implements ITreeContentProvider {
    private final AbstractConfigFormPage page;

    public SpringConfigContentProvider(AbstractConfigFormPage page) {
        this.page = page;
    }

    public void dispose() {
    }

    protected List<String> getChildNames(IDOMElement element) {
        return this.page.getXmlProcessor().getChildNames(element);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Node> result = new ArrayList<Node>();
        String uri = this.page.getNamespaceUri();
        if (parentElement instanceof IDOMElement) {
            IDOMElement node = (IDOMElement)parentElement;
            Node grandParent = node.getParentNode();
            NodeList list = node.getChildNodes();
            List<String> children = this.getChildNames(node);
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                if (child.getNodeType() == 1) {
                    if (uri == null || uri.equals(child.getNamespaceURI()) || this.isAdapterNamespace(child.getNamespaceURI())) {
                        result.add(child);
                    } else if (!(grandParent instanceof Document) && children.contains(child.getNodeName())) {
                        result.add(child);
                    }
                }
                ++i;
            }
        }
        return result.toArray();
    }

    public Object[] getElements(Object inputElement) {
        Element root;
        ArrayList<Element> result = new ArrayList<Element>();
        if (inputElement instanceof Document && (root = ((Document)inputElement).getDocumentElement()) != null) {
            result.add(root);
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof Node) {
            Node node = (Node)element;
            return node.getParentNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private boolean isAdapterNamespace(String uri) {
        if (uri != null) {
            for (IConfigurationElement config : this.page.getAdapterDefinitions()) {
                if (!uri.equals(config.getAttribute(PageAdaptersExtensionPointConstants.ATTR_NAMESPACE_URI))) continue;
                return true;
            }
        }
        return false;
    }
}

