/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.core.formatting.ShallowFormatProcessorXML;

public abstract class TreeViewerNodeAction
extends Action {
    protected TreeViewer treeViewer;
    private TreeItem selection;
    private TreeItem prevItem;
    private TreeItem nextItem;
    protected ShallowFormatProcessorXML formatter;
    protected SpringConfigContentAssistProcessor processor;

    public TreeViewerNodeAction(TreeViewer treeViewer, SpringConfigContentAssistProcessor processor) {
        this.treeViewer = treeViewer;
        this.processor = processor;
        this.formatter = new ShallowFormatProcessorXML();
    }

    protected IDOMElement getElementFromTreeItem(TreeItem item) {
        Object data;
        if (item != null && (data = item.getData()) != null && data instanceof IDOMElement) {
            return (IDOMElement)data;
        }
        return null;
    }

    public TreeItem getNextTreeItem() {
        return this.nextItem;
    }

    public TreeItem getPreviousTreeItem() {
        return this.prevItem;
    }

    public TreeItem getSelectedTreeItem() {
        return this.selection;
    }

    protected void resolveSelection() {
        TreeItem[] items;
        this.selection = null;
        this.prevItem = null;
        this.nextItem = null;
        if (this.treeViewer != null && (items = this.treeViewer.getTree().getSelection()).length > 0) {
            this.selection = items[0];
            TreeItem parent = this.selection.getParentItem();
            if (parent != null) {
                int index = parent.indexOf(this.selection);
                if (index > 0) {
                    this.prevItem = parent.getItem(index - 1);
                }
                if (index + 1 < parent.getItemCount()) {
                    this.nextItem = parent.getItem(index + 1);
                }
            }
        }
    }

    public void run() {
        this.resolveSelection();
    }
}

