/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package javax.jms;

/**
 * <P> This exception must be thrown when a 
 *     JMS client attempts to give a provider a message selector with 
 *     invalid syntax.
 **/

public class InvalidSelectorException extends JMSException {

  /** Constructs an <CODE>InvalidSelectorException</CODE> with the specified 
   *  reason and error code.
   *
   *  @param  reason        a description of the exception
   *  @param  errorCode     a string specifying the vendor-specific
   *                        error code
   *                        
   **/
  public 
  InvalidSelectorException(String reason, String errorCode) {
    super(reason, errorCode);
  }

  /** Constructs an <CODE>InvalidSelectorException</CODE> with the specified 
   *  reason. The error code defaults to null.
   *
   *  @param  reason        a description of the exception
   **/
  public 
  InvalidSelectorException(String reason) {
    super(reason);
  }

}
