/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class CreateExceptionHandlerCommand
extends Command {
    private IExceptionHandler child;
    private int index = -1;
    private boolean isMove = false;
    private boolean createNew = true;
    private IState parent;

    public void execute() {
        if (this.createNew) {
            this.child.createNew((IWebflowModelElement)this.parent);
        }
        if (!this.isMove && DialogUtils.openPropertiesDialog(null, (IWebflowModelElement)this.child, true) != 0) {
            return;
        }
        if (this.index > 0) {
            this.parent.addExceptionHandler(this.child, this.index);
        } else {
            this.parent.addExceptionHandler(this.child);
        }
    }

    public void setChild(IExceptionHandler action) {
        this.child = action;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setMove(boolean isMove) {
        this.isMove = isMove;
    }

    public void setParent(IState sa) {
        this.parent = sa;
    }

    public void undo() {
        this.parent.removeExceptionHandler(this.child);
    }

    public void redo() {
        boolean tempMove = this.isMove;
        boolean tempCreateNew = this.createNew;
        this.isMove = true;
        this.createNew = false;
        this.execute();
        this.isMove = tempMove;
        this.createNew = tempCreateNew;
    }
}

