/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.figures;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.springframework.ide.eclipse.config.graph.figures.SimpleActivityLabel;

public class TransitionLabel
extends SimpleActivityLabel {
    private int maxLength;
    private String subStringText;

    public TransitionLabel() {
        this(-1);
    }

    public TransitionLabel(int maxLength) {
        super(16);
        this.maxLength = maxLength;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int hint = this.maxLength < 0 ? wHint : this.maxLength;
        return super.getPreferredSize(hint, this.calculateTextSize().height);
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public String getSubStringText() {
        this.subStringText = this.getText();
        int widthShrink = this.getTextSize().width - this.getPreferredSize().width;
        if (widthShrink <= 0) {
            return this.subStringText;
        }
        Dimension effectiveSize = this.getTextSize().getExpanded(-widthShrink, 0);
        Font currentFont = this.getFont();
        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(this.getText(), currentFont, effectiveSize.width - dotsWidth);
        this.subStringText = new String(String.valueOf(this.getText().substring(0, subStringLength)) + this.getTruncationString());
        return this.subStringText;
    }
}

