/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.jobs;

import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.config.CheckstyleConfigurationFile;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.configtypes.IContextAware;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.transformer.CheckstyleTransformer;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xml.sax.InputSource;

public class TransformCheckstyleRulesJob
extends WorkspaceJob {
    private IProject mProject;

    public TransformCheckstyleRulesJob(IProject project) {
        super("transformCheckstyle");
        this.mProject = project;
    }

    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
        try {
            IProjectConfiguration conf = ProjectConfigurationFactory.getConfiguration(this.mProject);
            ArrayList<Configuration> rules = new ArrayList<Configuration>();
            for (FileSet fs : conf.getFileSets()) {
                ICheckConfiguration checkConfig = fs.getCheckConfig();
                CheckstyleConfigurationFile configFile = checkConfig.getCheckstyleConfiguration();
                PropertyResolver resolver = configFile.getPropertyResolver();
                if (resolver instanceof IContextAware) {
                    ((IContextAware)resolver).setProjectContext(this.mProject);
                }
                InputSource in = null;
                try {
                    in = configFile.getCheckConfigFileInputSource();
                    Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)in, (PropertyResolver)resolver, (boolean)true);
                    TransformCheckstyleRulesJob.recurseConfiguration(configuration, rules);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in.getByteStream());
                }
            }
            if (rules.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            CheckstyleTransformer transformer = new CheckstyleTransformer(this.mProject, rules);
            transformer.transformRules();
        }
        catch (CheckstyleException e) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (CheckstylePluginException e) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return Status.OK_STATUS;
    }

    private static void recurseConfiguration(Configuration module, List<Configuration> flatModules) {
        flatModules.add(module);
        Configuration[] childs = module.getChildren();
        if (childs != null && childs.length > 0) {
            Configuration[] configurationArray = childs;
            int n = childs.length;
            int n2 = 0;
            while (n2 < n) {
                Configuration child = configurationArray[n2];
                TransformCheckstyleRulesJob.recurseConfiguration(child, flatModules);
                ++n2;
            }
        }
    }
}

