/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.completions.externaltype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.springsource.ide.eclipse.commons.completions.CompletionsActivator;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscovery;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscoveryFactory;
import org.springsource.ide.eclipse.commons.completions.externaltype.indexing.ExternalTypeIndexer;
import org.springsource.ide.eclipse.commons.completions.externaltype.indexing.SimpleExternalTypeIndexer;

public class ExternalTypeIndexManager {
    private static final String TYPE_SOURCES_EXTENSION_POINT = "org.spring.ide.eclipse.completions.externaltypes";
    private static final ExternalTypeIndexManager INSTANCE = new ExternalTypeIndexManager();
    private ExternalTypeIndexer index = null;
    private Set<ExternalTypeDiscovery> contentKey = null;
    private static List<ExternalTypeDiscoveryFactory> factories = null;

    public static synchronized ExternalTypeIndexer indexFor(IJavaProject project) {
        return INSTANCE.getIndexFor(project);
    }

    public synchronized ExternalTypeIndexer getIndexFor(IJavaProject project) {
        HashSet<ExternalTypeDiscovery> newContentKey = new HashSet<ExternalTypeDiscovery>();
        for (ExternalTypeDiscoveryFactory factory : ExternalTypeIndexManager.getFactories()) {
            ExternalTypeDiscovery discovery = factory.discoveryFor(project);
            if (discovery == null) continue;
            newContentKey.add(discovery);
        }
        if (newContentKey.isEmpty()) {
            return ExternalTypeIndexer.EMPTY;
        }
        if (this.index != null && this.contentKey.equals(newContentKey)) {
            return this.index;
        }
        this.index = new SimpleExternalTypeIndexer();
        this.contentKey = newContentKey;
        Job rebuildIndex = new Job("Indexing Jar Types"){

            protected IStatus run(IProgressMonitor mon) {
                mon.beginTask("Indexing Jar Types", ExternalTypeIndexManager.this.contentKey.size());
                try {
                    for (ExternalTypeDiscovery discovery : ExternalTypeIndexManager.this.contentKey) {
                        ExternalTypeIndexManager.this.index.addFrom(discovery);
                        mon.worked(1);
                    }
                }
                finally {
                    mon.done();
                }
                return Status.OK_STATUS;
            }
        };
        rebuildIndex.setPriority(50);
        rebuildIndex.schedule();
        return this.index;
    }

    private static synchronized List<ExternalTypeDiscoveryFactory> getFactories() {
        if (factories == null) {
            IConfigurationElement[] confEls;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = confEls = registry.getConfigurationElementsFor(TYPE_SOURCES_EXTENSION_POINT);
            int n = confEls.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement confEl = iConfigurationElementArray[n2];
                String name = confEl.getName();
                if ("typeSource".equals(name)) {
                    try {
                        ExternalTypeDiscoveryFactory factory = (ExternalTypeDiscoveryFactory)confEl.createExecutableExtension("class");
                        if (factories == null) {
                            factories = new ArrayList<ExternalTypeDiscoveryFactory>(confEls.length);
                        }
                        factories.add(factory);
                    }
                    catch (CoreException e) {
                        CompletionsActivator.log(e);
                    }
                }
                ++n2;
            }
            if (factories == null || factories.isEmpty()) {
                factories = Collections.emptyList();
            }
        }
        return factories;
    }
}

