/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim;

import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.browser.PlatformUtil;
import org.jboss.tools.browsersim.browser.javafx.JavaFXBrowser;
import org.jboss.tools.browsersim.ui.BrowserSim;
import org.jboss.tools.browsersim.ui.ControlHandler;
import org.jboss.tools.browsersim.ui.menu.BrowserSimMenuCreator;
import org.jboss.tools.browsersim.ui.model.preferences.CommonPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferences;
import org.jboss.tools.browsersim.ui.model.preferences.SpecificPreferencesStorage;
import org.jboss.tools.browsersim.ui.skin.BrowserSimSkin;
import org.jboss.tools.cordovasim.CordovaSimControlHandler;
import org.jboss.tools.cordovasim.CordovaSimMenuCreator;
import org.jboss.tools.cordovasim.model.preferences.CordavaSimSpecificPreferencesStorage;
import org.jboss.tools.cordovasim.model.preferences.CordovaSimSpecificPreferences;

public class CustomBrowserSim
extends BrowserSim {
    private static final String GET_RIPPLE_PREFERENCES_SCRIPT = "return window.localStorage2.ripple";
    private IBrowser inAppBrowser;
    private IBrowser rippleToolSuiteBrowser;

    public CustomBrowserSim(String homeUrl, Shell parentShell) {
        super(homeUrl, parentShell);
    }

    protected ControlHandler createControlHandler(IBrowser browser, String homeUrl, SpecificPreferences specificPreferences) {
        return new CordovaSimControlHandler(browser, homeUrl, specificPreferences);
    }

    protected BrowserSimMenuCreator createMenuCreator(BrowserSimSkin skin, CommonPreferences commonPreferences, SpecificPreferences specificPreferences, ControlHandler controlHandler, String homeUrl) {
        return new CordovaSimMenuCreator(skin, commonPreferences, specificPreferences, controlHandler, homeUrl);
    }

    protected SpecificPreferencesStorage getSpecificPreferencesStorage() {
        return CordavaSimSpecificPreferencesStorage.INSTANCE;
    }

    public CordovaSimSpecificPreferences getSpecificPreferences() {
        return (CordovaSimSpecificPreferences)super.getSpecificPreferences();
    }

    protected void setSelectedDevice(Boolean refreshRequired) {
        String currentOs = PlatformUtil.getOs();
        if (this.inAppBrowser != null && refreshRequired == null && (!"win32".equals(currentOs) || this.inAppBrowser instanceof JavaFXBrowser)) {
            this.rippleToolSuiteBrowser.execute("(function(){ripple('platform/cordova/3.0.0/bridge/inappbrowser').close();})()");
        }
        super.setSelectedDevice(refreshRequired);
        if ("win32".equals(currentOs) && this.inAppBrowser != null && !(this.inAppBrowser instanceof JavaFXBrowser) && refreshRequired == null) {
            this.inAppBrowser = null;
            this.rippleToolSuiteBrowser.refresh();
        }
    }

    protected LocationListener createNavButtonsListener() {
        return new LocationAdapter(){

            public void changed(LocationEvent event) {
                if (event.top) {
                    CustomBrowserSim.this.skin.locationChanged(event.location, true, true);
                }
            }
        };
    }

    protected void cleanUpOnClose(Shell shell) {
        this.saveRipplePreferences(this.getRippleToolBarBrowser(), this.getSpecificPreferences());
        super.cleanUpOnClose(shell);
    }

    protected boolean isAddressBarVisibleByDefault() {
        return false;
    }

    protected boolean isUrlResettingNeededAfterSkinChange() {
        return false;
    }

    public IBrowser getInAppBrowser() {
        return this.inAppBrowser;
    }

    public void setInAppBrowser(IBrowser inAppBrowser) {
        this.inAppBrowser = inAppBrowser;
    }

    public IBrowser getRippleToolBarBrowser() {
        return this.rippleToolSuiteBrowser;
    }

    public void setRippleToolBarBrowser(IBrowser rippleToolBarBrowser) {
        this.rippleToolSuiteBrowser = rippleToolBarBrowser;
    }

    private void saveRipplePreferences(IBrowser rippleToolBarBrowser, CordovaSimSpecificPreferences sp) {
        String preferences;
        Object ripplePreferences = rippleToolBarBrowser.evaluate(GET_RIPPLE_PREFERENCES_SCRIPT);
        if (ripplePreferences != null && rippleToolBarBrowser != null && !rippleToolBarBrowser.isDisposed() && !(preferences = (String)ripplePreferences).equals("undefined")) {
            sp.setRipplePreferences(preferences);
        }
    }
}

