/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.jira.core.service.rest;

import com.atlassian.connector.eclipse.internal.jira.core.model.Component;
import com.atlassian.connector.eclipse.internal.jira.core.model.CustomField;
import com.atlassian.connector.eclipse.internal.jira.core.model.IssueField;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraAction;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraIssue;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraStatus;
import com.atlassian.connector.eclipse.internal.jira.core.model.JiraWorkLog;
import com.atlassian.connector.eclipse.internal.jira.core.model.NamedFilter;
import com.atlassian.connector.eclipse.internal.jira.core.model.Priority;
import com.atlassian.connector.eclipse.internal.jira.core.model.Resolution;
import com.atlassian.connector.eclipse.internal.jira.core.model.ServerInfo;
import com.atlassian.connector.eclipse.internal.jira.core.model.Version;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraAuthenticationException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraClientCache;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraException;
import com.atlassian.connector.eclipse.internal.jira.core.service.JiraServiceUnavailableException;
import com.atlassian.connector.eclipse.internal.jira.core.service.rest.JiraRestConverter;
import com.atlassian.jira.rest.client.AuthenticationHandler;
import com.atlassian.jira.rest.client.GetCreateIssueMetadataOptionsBuilder;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.domain.BasicPriority;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.domain.CimIssueType;
import com.atlassian.jira.rest.client.domain.CimProject;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.IssueType;
import com.atlassian.jira.rest.client.domain.Project;
import com.atlassian.jira.rest.client.domain.SecurityLevel;
import com.atlassian.jira.rest.client.domain.SessionInfo;
import com.atlassian.jira.rest.client.domain.input.ComplexIssueInputFieldValue;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.client.apache.config.ApacheHttpClientConfig;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.osgi.util.NLS;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRestClientAdapter {
    private static final Integer TIMEOUT_CONNECTION_IN_MS = new Integer(60000);
    private static final Integer TIMEOUT_READ_IN_MS = new Integer(600000);
    private static final String CONNECT_TIMEOUT_EXCEPTION = "org.apache.commons.httpclient.ConnectTimeoutException";
    private static final String SOCKET_TIMEOUT_EXCEPTION = "java.net.SocketTimeoutException";
    private static final SimpleDateFormat REST_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat REST_DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String HTTP_401 = "Client response status: 401";
    private static final String HTTP_403 = "Client response status: 403";
    public static final String HTTP_404 = "Client response status: 404";
    private static final String HTTP_302 = "Client response status: 302";
    private static final String CONNECTION_REFUSED = "java.net.ConnectException: Connection refused: connect";
    private static final String UNKNOWN_HOST_EXCEPTION = "java.net.UnknownHostException:";
    private static final String ILLEGAL_ARGUMENT_EXCEPTION = "java.lang.IllegalArgumentException:";
    private static final String NULL_POINTER_EXCEPTION = "java.lang.NullPointerException";
    private JiraRestClient restClient;
    private final JiraClientCache cache;
    private final String url;
    private final boolean followRedirects;

    public JiraRestClientAdapter(String url, JiraClientCache cache, boolean followRedirects) {
        this.url = url;
        this.cache = cache;
        this.followRedirects = followRedirects;
    }

    public JiraRestClientAdapter(String url, String userName, String password, final Proxy proxy, JiraClientCache cache, boolean followRedirects) {
        this(url, cache, followRedirects);
        try {
            this.restClient = new JerseyJiraRestClientBuilder().header("User-Agent", "Atlassian Connector for Eclipse").queryParam("requestSource", "eclipse-ide-connector").create(new URI(url), (AuthenticationHandler)new BasicHttpAuthenticationHandler(userName, password){

                public void configure(ApacheHttpClientConfig config) {
                    super.configure(config);
                    if (proxy != null) {
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        if (proxy instanceof AuthenticatedProxy) {
                            AuthenticatedProxy authProxy = (AuthenticatedProxy)proxy;
                            config.getState().setProxyCredentials(AuthScope.ANY_REALM, address.getHostName(), address.getPort(), authProxy.getUserName(), authProxy.getPassword());
                        }
                    }
                    config.getProperties().put("com.sun.jersey.client.property.connectTimeout", TIMEOUT_CONNECTION_IN_MS);
                    config.getProperties().put("com.sun.jersey.client.property.readTimeout", TIMEOUT_READ_IN_MS);
                }
            }, followRedirects);
            if (proxy != null) {
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                this.restClient.getTransportClient().getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + address.getHostName() + ":" + address.getPort());
            }
        }
        catch (URISyntaxException e) {
            StatusHandler.log((IStatus)new Status(4, "com.atlassian.connector.eclipse.internal.jira.core", e.getMessage()));
        }
    }

    public void addComment(final String issueKey, final String comment) throws JiraException {
        this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JiraRestClientAdapter.this.restClient.getIssueClient().addComment((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor(), JiraRestClientAdapter.this.getIssue(issueKey).getCommentsUri(), Comment.valueOf((String)comment));
                return null;
            }
        });
    }

    private Issue getIssue(final String issueKeyOrId) throws JiraException {
        return this.call(new Callable<Issue>(){

            @Override
            public Issue call() {
                return JiraRestClientAdapter.this.restClient.getIssueClient().getIssue(issueKeyOrId, (Iterable)ImmutableList.of((Object)IssueRestClient.Expandos.EDITMETA, (Object)IssueRestClient.Expandos.SCHEMA), (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
            }
        });
    }

    public void addAttachment(String issueKey, byte[] content, String filename) throws JiraException {
        this.restClient.getIssueClient().addAttachment((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor(), this.getIssue(issueKey).getAttachmentsUri(), (InputStream)new ByteArrayInputStream(content), filename);
    }

    public InputStream getAttachment(URI attachmentUri) {
        return this.restClient.getIssueClient().getAttachment((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor(), attachmentUri);
    }

    public com.atlassian.connector.eclipse.internal.jira.core.model.Project[] getProjects() {
        Iterable allProjects = this.restClient.getProjectClient().getAllProjects((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
        return JiraRestConverter.convertProjects(allProjects);
    }

    public NamedFilter[] getFavouriteFilters() throws JiraException {
        return this.call(new Callable<NamedFilter[]>(){

            @Override
            public NamedFilter[] call() throws Exception {
                return JiraRestConverter.convertNamedFilters(JiraRestClientAdapter.this.restClient.getSearchClient().getFavouriteFilters(new com.atlassian.jira.rest.client.NullProgressMonitor()));
            }
        });
    }

    public Resolution[] getResolutions() {
        return JiraRestConverter.convertResolutions(this.restClient.getMetadataClient().getResolutions((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
    }

    public Priority[] getPriorities() {
        return JiraRestConverter.convertPriorities(this.restClient.getMetadataClient().getPriorities((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
    }

    public JiraIssue getIssueByKeyOrId(String issueKeyOrId, IProgressMonitor monitor) throws JiraException {
        return JiraRestConverter.convertIssue(this.getIssue(issueKeyOrId), this.cache, this.url, monitor);
    }

    public JiraStatus[] getStatuses() {
        return JiraRestConverter.convertStatuses(this.restClient.getMetadataClient().getStatuses((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
    }

    public com.atlassian.connector.eclipse.internal.jira.core.model.IssueType[] getIssueTypes() {
        return JiraRestConverter.convertIssueTypes(this.restClient.getMetadataClient().getIssueTypes((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
    }

    public com.atlassian.connector.eclipse.internal.jira.core.model.IssueType[] getIssueTypes(String projectKey) {
        return JiraRestConverter.convertIssueTypes((Iterable<IssueType>)this.restClient.getProjectClient().getProject(projectKey, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()).getIssueTypes());
    }

    public List<JiraIssue> getIssues(final String jql, final int maxSearchResult, final IProgressMonitor monitor) throws JiraException {
        return this.call(new Callable<List<JiraIssue>>(){

            @Override
            public List<JiraIssue> call() throws Exception {
                List<JiraIssue> issues = JiraRestConverter.convertIssues(JiraRestClientAdapter.this.restClient.getSearchClient().searchJql(jql, maxSearchResult, 0, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()).getIssues());
                ArrayList<JiraIssue> fullIssues = new ArrayList<JiraIssue>();
                for (JiraIssue issue : issues) {
                    fullIssues.add(JiraRestConverter.convertIssue(JiraRestClientAdapter.this.getIssue(issue.getKey()), JiraRestClientAdapter.this.cache, JiraRestClientAdapter.this.url, monitor));
                }
                return fullIssues;
            }
        });
    }

    public void getProjectDetails(com.atlassian.connector.eclipse.internal.jira.core.model.Project project) {
        Project projectWithDetails = this.restClient.getProjectClient().getProject(project.getKey(), (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
        project.setComponents(JiraRestConverter.convertComponents(projectWithDetails.getComponents()));
        project.setVersions(JiraRestConverter.convertVersions(projectWithDetails.getVersions()));
        project.setIssueTypes(JiraRestConverter.convertIssueTypes((Iterable<IssueType>)projectWithDetails.getIssueTypes()));
    }

    public void addWorklog(String issueKey, JiraWorkLog jiraWorklog) throws JiraException {
        Issue issue = this.getIssue(issueKey);
        this.restClient.getIssueClient().addWorklog(issue.getWorklogUri(), JiraRestConverter.convert(jiraWorklog, issue.getSelf()), (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
    }

    public ServerInfo getServerInfo() throws JiraException {
        return this.call(new Callable<ServerInfo>(){

            @Override
            public ServerInfo call() {
                return JiraRestConverter.convert(JiraRestClientAdapter.this.restClient.getMetadataClient().getServerInfo((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
            }
        });
    }

    public SessionInfo getSessionInfo() throws JiraException {
        return this.call(new Callable<SessionInfo>(){

            @Override
            public SessionInfo call() {
                return JiraRestClientAdapter.this.restClient.getMetadataClient().getSessionInfo((ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
            }
        });
    }

    public Iterable<JiraAction> getTransitions(String issueKey) throws JiraException {
        URI transitionUri = UriBuilder.fromUri((String)this.url).path("/rest/api/latest").path("issue").path(issueKey).path("transitions").queryParam("expand", new Object[]{"transitions.fields"}).build(new Object[0]);
        return JiraRestConverter.convertTransitions(this.restClient.getIssueClient().getTransitions(transitionUri, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()));
    }

    public void transitionIssue(JiraIssue issue, String transitionKey, String comment, Iterable<IssueField> transitionFields) throws JiraException {
        Comment outComment = StringUtils.isEmpty((String)comment) ? null : Comment.valueOf((String)comment);
        ArrayList<FieldInput> fields = new ArrayList<FieldInput>();
        for (IssueField transitionField : transitionFields) {
            if (!transitionField.isRequired()) continue;
            String[] values = issue.getFieldValues(transitionField.getName());
            if (values != null && values.length > 0) {
                if (transitionField.getName().equals("summary") || transitionField.getName().equals("description") || transitionField.getName().equals("environment")) {
                    fields.add(new FieldInput(transitionField.getName(), (Object)values[0]));
                    continue;
                }
                if (transitionField.getName().equals("duedate")) {
                    String date = new DateTime((Object)issue.getDue()).toString("yyyy-MM-dd");
                    if (values[0] == null) {
                        date = null;
                    }
                    fields.add(new FieldInput("duedate", (Object)date));
                    continue;
                }
                if (transitionField.getName().equals("labels")) {
                    fields.add(new FieldInput(transitionField.getName(), Arrays.asList(values)));
                    continue;
                }
                if (transitionField.getName().equals("resolution") || transitionField.getName().equals("issuetype") || transitionField.getName().equals("priority") || transitionField.getName().equals("security")) {
                    fields.add(new FieldInput(transitionField.getId(), (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)values[0])));
                    continue;
                }
                if (transitionField.getType() != null && transitionField.getType().equals("array") && !transitionField.getName().startsWith("customfield_")) {
                    ArrayList<ComplexIssueInputFieldValue> array = new ArrayList<ComplexIssueInputFieldValue>();
                    String[] stringArray = values;
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        array.add(ComplexIssueInputFieldValue.with((String)"id", (Object)value));
                        ++n2;
                    }
                    fields.add(new FieldInput(transitionField.getId(), array));
                    continue;
                }
                if (transitionField.getName().startsWith("customfield_")) {
                    CustomField customField = issue.getCustomFieldById(transitionField.getId());
                    FieldInput field = JiraRestConverter.convert(customField);
                    if (field == null) continue;
                    fields.add(field);
                    continue;
                }
                fields.add(new FieldInput(transitionField.getName(), (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)values[0])));
                continue;
            }
            String name = transitionField.getName();
            String message = "Field \"{0}\" is required for transition id \"{1}\"";
            if (name.startsWith("customfield_")) {
                CustomField customField = issue.getCustomFieldById(transitionField.getId());
                if (customField != null) {
                    name = customField.getName();
                } else {
                    message = String.valueOf(message) + " but is not present on the Issue Edit screen.";
                }
            }
            throw new JiraException(NLS.bind((String)message, (Object)name, (Object)transitionKey));
        }
        TransitionInput transitionInput = new TransitionInput(Integer.parseInt(transitionKey), fields, outComment);
        this.restClient.getIssueClient().transition(this.getIssue(issue.getKey()), transitionInput, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
    }

    public void assignIssue(String issueKey, String user, String comment) throws JiraException {
        Issue issue = this.getIssue(issueKey);
        ImmutableList fields = ImmutableList.of((Object)new FieldInput("assignee", (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)user)));
        this.restClient.getIssueClient().update(issue, (Iterable)fields, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
    }

    public String createIssue(JiraIssue issue) throws JiraException {
        long issueTypeId;
        if (issue.getProject() == null || issue.getProject().getKey() == null || StringUtils.isEmpty((String)issue.getProject().getKey())) {
            throw new JiraException("Project must be set.");
        }
        if (issue.getSummary() == null || StringUtils.isEmpty((String)issue.getSummary())) {
            throw new JiraException("Summary must be set.");
        }
        if (issue.getType() == null || issue.getType().getId() == null || StringUtils.isEmpty((String)issue.getType().getId())) {
            throw new JiraException("Issue type must be set.");
        }
        try {
            issueTypeId = Long.parseLong(issue.getType().getId());
        }
        catch (NumberFormatException e) {
            throw new JiraException("Incorrect issue type.", e);
        }
        final IssueInputBuilder issueInputBuilder = new IssueInputBuilder(issue.getProject().getKey(), Long.valueOf(issueTypeId), issue.getSummary());
        if (issue.getComponents() != null && issue.getComponents().length > 0) {
            issueInputBuilder.setComponents(JiraRestConverter.convert(issue.getComponents()));
        }
        if (!StringUtils.isEmpty((String)issue.getDescription())) {
            issueInputBuilder.setDescription(issue.getDescription());
        }
        if (issue.getAssignee() != null && !issue.getAssignee().equals("-1")) {
            issueInputBuilder.setAssignee(new BasicUser(null, issue.getAssignee(), null));
        }
        if (issue.getDue() != null) {
            issueInputBuilder.setDueDate(new DateTime((Object)issue.getDue()));
        }
        if (issue.getReportedVersions() != null && issue.getReportedVersions().length > 0) {
            issueInputBuilder.setAffectedVersions(JiraRestConverter.convert(issue.getReportedVersions()));
        }
        if (issue.getFixVersions() != null && issue.getFixVersions().length > 0) {
            issueInputBuilder.setFixVersions(JiraRestConverter.convert(issue.getFixVersions()));
        }
        if (issue.getPriority() == null || StringUtils.isEmpty((String)issue.getPriority().getId())) {
            throw new JiraException("Priority not set");
        }
        issueInputBuilder.setPriority(new BasicPriority(null, Long.valueOf(issue.getPriority().getId()), issue.getPriority().getName()));
        if (!StringUtils.isEmpty((String)issue.getEnvironment())) {
            issueInputBuilder.setFieldInput(new FieldInput("environment", (Object)issue.getEnvironment()));
        }
        if (issue.getEstimate() != null) {
            ImmutableMap map = ImmutableMap.builder().put((Object)"originalEstimate", (Object)(String.valueOf(String.valueOf(issue.getEstimate() / 60L)) + "m")).put((Object)"remainingEstimate", (Object)(String.valueOf(String.valueOf(issue.getEstimate() / 60L)) + "m")).build();
            issueInputBuilder.setFieldInput(new FieldInput("timetracking", (Object)new ComplexIssueInputFieldValue((Map)map)));
        }
        if (issue.getSecurityLevel() != null) {
            issueInputBuilder.setFieldValue("security", ComplexIssueInputFieldValue.with((String)"id", (Object)issue.getSecurityLevel().getId()));
        }
        if (!StringUtils.isEmpty((String)issue.getParentKey())) {
            issueInputBuilder.setFieldInput(new FieldInput("parent", (Object)ComplexIssueInputFieldValue.with((String)"key", (Object)issue.getParentKey())));
        } else if (!StringUtils.isEmpty((String)issue.getParentId())) {
            issueInputBuilder.setFieldInput(new FieldInput("parent", (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)issue.getParentId())));
        }
        return this.call(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return JiraRestClientAdapter.this.restClient.getIssueClient().createIssue(issueInputBuilder.build(), (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor()).getKey();
            }
        });
    }

    public void updateIssue(JiraIssue changedIssue, boolean updateEstimate) throws JiraException {
        Serializable version;
        ImmutableMap map;
        JiraIssue fullIssue = this.getIssueByKeyOrId(changedIssue.getKey(), (IProgressMonitor)new NullProgressMonitor());
        final Issue issue = fullIssue.getRawIssue();
        List<IssueField> editableFields = Arrays.asList(fullIssue.getEditableFields());
        final ArrayList<FieldInput> updateFields = new ArrayList<FieldInput>();
        updateFields.add(new FieldInput("issuetype", (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)changedIssue.getType().getId())));
        if (editableFields.contains(new IssueField("priority", null)) && changedIssue.getPriority() != null) {
            updateFields.add(new FieldInput("priority", (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)changedIssue.getPriority().getId())));
        }
        if (editableFields.contains(new IssueField("duedate", null))) {
            String date = new DateTime((Object)changedIssue.getDue()).toString("yyyy-MM-dd");
            if (changedIssue.getDue() == null) {
                date = null;
            }
            updateFields.add(new FieldInput("duedate", (Object)date));
        }
        if (issue.getTimeTracking() != null && updateEstimate) {
            Long currentEstimateInSeconds = changedIssue.getEstimate();
            Integer previousEstimateInMinutes = issue.getTimeTracking().getRemainingEstimateMinutes();
            String outputOriginalEstimateInMinutes = null;
            String outputRemainingEstimateInMinutes = null;
            if (currentEstimateInSeconds == null && previousEstimateInMinutes != null) {
                if (issue.getTimeTracking().getOriginalEstimateMinutes() != null) {
                    outputRemainingEstimateInMinutes = outputOriginalEstimateInMinutes = String.valueOf(issue.getTimeTracking().getOriginalEstimateMinutes());
                } else {
                    StatusHandler.log((IStatus)new Status(2, "com.atlassian.connector.eclipse.internal.jira.core", "Remaining Estimate is set but Original Estimate is null?"));
                }
            } else if (currentEstimateInSeconds != null && previousEstimateInMinutes == null || currentEstimateInSeconds != null && previousEstimateInMinutes != null && currentEstimateInSeconds / 60L != (long)previousEstimateInMinutes.intValue()) {
                outputOriginalEstimateInMinutes = outputRemainingEstimateInMinutes = String.valueOf(currentEstimateInSeconds / 60L);
                if (issue.getTimeTracking().getOriginalEstimateMinutes() != null && issue.getTimeTracking().getOriginalEstimateMinutes() != 0) {
                    outputOriginalEstimateInMinutes = String.valueOf(issue.getTimeTracking().getOriginalEstimateMinutes());
                }
            }
            if (outputOriginalEstimateInMinutes != null && outputRemainingEstimateInMinutes != null) {
                map = ImmutableMap.builder().put((Object)"originalEstimate", (Object)(String.valueOf(outputOriginalEstimateInMinutes) + "m")).put((Object)"remainingEstimate", (Object)(String.valueOf(outputRemainingEstimateInMinutes) + "m")).build();
                updateFields.add(new FieldInput("timetracking", (Object)new ComplexIssueInputFieldValue((Map)map)));
            }
        }
        if (editableFields.contains(new IssueField("versions", null))) {
            ArrayList<ComplexIssueInputFieldValue> reportedVersions = new ArrayList<ComplexIssueInputFieldValue>();
            map = changedIssue.getReportedVersions();
            int n = ((Version[])map).length;
            int n2 = 0;
            while (n2 < n) {
                version = map[n2];
                reportedVersions.add(ComplexIssueInputFieldValue.with((String)"id", (Object)((Version)version).getId()));
                ++n2;
            }
            updateFields.add(new FieldInput("versions", reportedVersions));
        }
        if (editableFields.contains(new IssueField("fixVersions", null))) {
            ArrayList<ComplexIssueInputFieldValue> fixVersions = new ArrayList<ComplexIssueInputFieldValue>();
            map = changedIssue.getFixVersions();
            int n = ((Version[])map).length;
            int n3 = 0;
            while (n3 < n) {
                version = map[n3];
                fixVersions.add(ComplexIssueInputFieldValue.with((String)"id", (Object)((Version)version).getId()));
                ++n3;
            }
            updateFields.add(new FieldInput("fixVersions", fixVersions));
        }
        if (editableFields.contains(new IssueField("components", null))) {
            ArrayList<ComplexIssueInputFieldValue> components = new ArrayList<ComplexIssueInputFieldValue>();
            map = changedIssue.getComponents();
            int n = ((Component[])map).length;
            int n4 = 0;
            while (n4 < n) {
                Serializable component = map[n4];
                components.add(ComplexIssueInputFieldValue.with((String)"id", (Object)((Component)component).getId()));
                ++n4;
            }
            updateFields.add(new FieldInput("components", components));
        }
        if (changedIssue.getSecurityLevel() != null) {
            updateFields.add(new FieldInput("security", (Object)ComplexIssueInputFieldValue.with((String)"id", (Object)changedIssue.getSecurityLevel().getId())));
        }
        if (editableFields.contains(new IssueField("environment", null))) {
            updateFields.add(new FieldInput("environment", (Object)changedIssue.getEnvironment()));
        }
        if (editableFields.contains(new IssueField("summary", null))) {
            updateFields.add(new FieldInput("summary", (Object)changedIssue.getSummary()));
        }
        if (editableFields.contains(new IssueField("description", null))) {
            updateFields.add(new FieldInput("description", (Object)(changedIssue.getDescription() != null ? changedIssue.getDescription() : "")));
        }
        if (editableFields.contains(new IssueField("assignee", null))) {
            String prevAssigne;
            String assigne = "-1".equals(changedIssue.getAssignee()) ? "" : changedIssue.getAssignee();
            String string = prevAssigne = issue.getAssignee() != null ? issue.getAssignee().getName() : "";
            if (!assigne.equals(prevAssigne)) {
                updateFields.add(new FieldInput("assignee", (Object)ComplexIssueInputFieldValue.with((String)"name", (Object)assigne)));
            }
        }
        if (editableFields.contains(new IssueField("labels", null))) {
            updateFields.add(new FieldInput("labels", Arrays.asList(changedIssue.getLabels())));
        }
        CustomField[] customFieldArray = changedIssue.getCustomFields();
        int n = customFieldArray.length;
        int n5 = 0;
        while (n5 < n) {
            CustomField customField = customFieldArray[n5];
            FieldInput field = JiraRestConverter.convert(customField);
            if (field != null) {
                updateFields.add(field);
            }
            ++n5;
        }
        this.call(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                JiraRestClientAdapter.this.restClient.getIssueClient().update(issue, (Iterable)updateFields, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
                return null;
            }
        });
    }

    private <V> V call(Callable<V> callable) throws JiraException {
        try {
            return callable.call();
        }
        catch (RestClientException e) {
            if (e.getMessage().contains(HTTP_401)) {
                throw new JiraAuthenticationException(HTTP_401);
            }
            if (e.getMessage().contains(HTTP_403)) {
                throw new JiraException("Client response status: 403. Captcha might be required. Please try to log in via browser.");
            }
            if (e.getMessage().contains(CONNECTION_REFUSED)) {
                throw new JiraException(CONNECTION_REFUSED, e);
            }
            if (e.getMessage().contains(UNKNOWN_HOST_EXCEPTION)) {
                int index = e.getMessage().indexOf(UNKNOWN_HOST_EXCEPTION);
                throw new JiraServiceUnavailableException(e.getMessage().substring(index));
            }
            if (e.getMessage().contains(ILLEGAL_ARGUMENT_EXCEPTION)) {
                int index = e.getMessage().indexOf(ILLEGAL_ARGUMENT_EXCEPTION);
                throw new JiraException(e.getMessage().substring(index), e);
            }
            if (e.getMessage().contains(HTTP_302)) {
                int index = e.getMessage().indexOf(HTTP_302);
                throw new JiraException(String.valueOf(e.getMessage().substring(index)) + ". Https might be required.", e);
            }
            if (e.getMessage().contains(HTTP_404)) {
                throw new JiraServiceUnavailableException(e);
            }
            if (e.getMessage().contains("is not supported in Legacy Mode")) {
                throw new JiraException(String.valueOf(e.getMessage()) + " Please disable time tracking \"Legacy Mode\" in JIRA.", e);
            }
            if (e.getMessage().contains(NULL_POINTER_EXCEPTION)) {
                throw new RuntimeException(e);
            }
            if (e.getMessage().contains("Client response status: 301") && !this.followRedirects) {
                throw new JiraException("Client response status: 301. Please enable 'Follow redirects' checkbox for task repository.", e);
            }
            if (e.getMessage().contains(SOCKET_TIMEOUT_EXCEPTION)) {
                int index = e.getMessage().indexOf(SOCKET_TIMEOUT_EXCEPTION);
                throw new JiraException(e.getMessage().substring(index), e);
            }
            if (e.getMessage().contains(CONNECT_TIMEOUT_EXCEPTION)) {
                int index = e.getMessage().indexOf(CONNECT_TIMEOUT_EXCEPTION);
                throw new JiraException(e.getMessage().substring(index), e);
            }
            if (e.getMessage().contains("unable to find valid certification path")) {
                throw new JiraException("Connection failed. JIRA self-signed certificates are not supported.\nFor workaround see https://ecosystem.atlassian.net/browse/PLE-1430", e);
            }
            throw new JiraException(e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new JiraException(e);
        }
    }

    public static SimpleDateFormat getDateTimeFormat() {
        return REST_DATETIME_FORMAT;
    }

    public static SimpleDateFormat getDateFormat() {
        return REST_DATE_FORMAT;
    }

    public com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel[] getSecurityLevels(String projectKey) throws JiraException {
        CimProject cimProject;
        GetCreateIssueMetadataOptionsBuilder builder = new GetCreateIssueMetadataOptionsBuilder();
        Iterable createIssueMetadata = this.restClient.getIssueClient().getCreateIssueMetadata(builder.withExpandedIssueTypesFields().withProjectKeys(new String[]{projectKey}).build(), (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
        if (createIssueMetadata.iterator().hasNext() && (cimProject = (CimProject)createIssueMetadata.iterator().next()).getIssueTypes().iterator().hasNext()) {
            CimIssueType cimIssueType = (CimIssueType)cimProject.getIssueTypes().iterator().next();
            CimFieldInfo cimFieldSecurity = (CimFieldInfo)cimIssueType.getFields().get("security");
            if (cimFieldSecurity != null) {
                Iterable allowedValues = cimFieldSecurity.getAllowedValues();
                ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel> securityLevels = new ArrayList<com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel>();
                for (Object allowedValue : allowedValues) {
                    if (!(allowedValue instanceof SecurityLevel)) continue;
                    SecurityLevel securityLevel = (SecurityLevel)allowedValue;
                    securityLevels.add(new com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel(securityLevel.getId().toString(), securityLevel.getName()));
                }
                return securityLevels.toArray(new com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel[securityLevels.size()]);
            }
            return new com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel[0];
        }
        return new com.atlassian.connector.eclipse.internal.jira.core.model.SecurityLevel[0];
    }

    public void deleteIssue(final String key, IProgressMonitor monitor) throws JiraException {
        this.call(new Callable<Void>(){

            @Override
            public Void call() {
                JiraRestClientAdapter.this.restClient.getIssueClient().removeIssue(key, true, (ProgressMonitor)new com.atlassian.jira.rest.client.NullProgressMonitor());
                return null;
            }
        });
    }
}

