/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdType;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansRefactoringChangeUtils {
    public static Change createConstructorArgumentRenameChange(IFile file, IJavaElement affectedElement, String newName, IProgressMonitor pm) throws CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model == null) {
                return null;
            }
            IDOMDocument document = ((DOMModelImpl)model).getDocument();
            MultiTextEdit multiEdit = new MultiTextEdit();
            NodeList nodes = document.getElementsByTagName("bean");
            int i = 0;
            while (i < nodes.getLength()) {
                Set<TextEdit> edits = BeansRefactoringChangeUtils.createConstructorTextEdits(nodes.item(i), affectedElement, newName, file);
                if (edits != null) {
                    multiEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                }
                ++i;
            }
            if (multiEdit.hasChildren()) {
                TextFileChange change = new TextFileChange("", file);
                change.setEdit((TextEdit)multiEdit);
                TextEdit[] textEditArray = multiEdit.getChildren();
                int n = textEditArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit e = textEditArray[n2];
                    change.addTextEditGroup(new TextEditGroup("Rename constructor argument", e));
                    ++n2;
                }
                TextFileChange textFileChange = change;
                return textFileChange;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private static Set<TextEdit> createConstructorTextEdits(Node node, IJavaElement element, String newName, IFile file) {
        if (node == null) {
            return null;
        }
        HashSet<TextEdit> result = new HashSet<TextEdit>();
        if (element instanceof ILocalVariable && node.hasAttributes()) {
            String argumentName = element.getElementName();
            String attributeNameStart = "c:";
            String optionalAttributeNameEnd = "-ref";
            NamedNodeMap attributes = node.getAttributes();
            int attributeCount = attributes.getLength();
            int i = 0;
            while (i < attributeCount) {
                AttrImpl attribute = (AttrImpl)attributes.item(i);
                String attributeName = attribute.getNodeName();
                if (attributeName != null && attributeName.startsWith(attributeNameStart) && (attributeName.equals(String.valueOf(attributeNameStart) + argumentName) || attributeName.equals(String.valueOf(attributeNameStart) + argumentName + optionalAttributeNameEnd))) {
                    List types = BeansEditorUtils.getClassNamesOfBean((IFile)file, (Node)node);
                    if (element.getParent() != null && element.getParent() instanceof IMethod && types.contains(((IMethod)element.getParent()).getDeclaringType())) {
                        int offset = attribute.getNameRegionStartOffset() + attributeNameStart.length();
                        result.add((TextEdit)new ReplaceEdit(offset, argumentName.length(), newName));
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static Change createMethodRenameChange(IFile file, IJavaElement[] affectedElements, String[] newNames, IProgressMonitor pm) throws CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model == null) {
                return null;
            }
            IDOMDocument document = ((DOMModelImpl)model).getDocument();
            MultiTextEdit multiEdit = new MultiTextEdit();
            NodeList nodes = document.getElementsByTagName("bean");
            int j = 0;
            while (j < affectedElements.length) {
                int i = 0;
                while (i < nodes.getLength()) {
                    Set<TextEdit> edits = BeansRefactoringChangeUtils.createMethodTextEdits(nodes.item(i), affectedElements[j], newNames[j], file);
                    if (edits != null) {
                        multiEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                    }
                    ++i;
                }
                ++j;
            }
            if (multiEdit.hasChildren()) {
                TextFileChange change = new TextFileChange("", file);
                change.setEdit((TextEdit)multiEdit);
                TextEdit[] textEditArray = multiEdit.getChildren();
                int n = textEditArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit e = textEditArray[n2];
                    change.addTextEditGroup(new TextEditGroup("Rename Bean property name", e));
                    ++n2;
                }
                TextFileChange textFileChange = change;
                return textFileChange;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private static Set<TextEdit> createMethodTextEdits(Node node, IJavaElement element, String newName, IFile file) {
        if (node == null) {
            return null;
        }
        HashSet<TextEdit> result = new HashSet<TextEdit>();
        if (element instanceof IMethod) {
            if (element.getElementName().startsWith("set")) {
                String methodName = StringUtils.uncapitalize((String)element.getElementName().substring(3));
                NodeList nodes = node.getChildNodes();
                int i = 0;
                while (i < nodes.getLength()) {
                    AttrImpl attr;
                    int offset;
                    List types;
                    String propertyName;
                    Node child = nodes.item(i);
                    if ("property".equals(child.getLocalName()) && BeansEditorUtils.hasAttribute((Node)child, (String)"name") && methodName.equals(propertyName = BeansEditorUtils.getAttribute((Node)child, (String)"name")) && (types = BeansEditorUtils.getClassNamesOfBean((IFile)file, (Node)node)).contains(((IMethod)element).getDeclaringType()) && (offset = (attr = (AttrImpl)child.getAttributes().getNamedItem("name")).getValueRegionStartOffset() + 1) >= 0) {
                        result.add((TextEdit)new ReplaceEdit(offset, propertyName.length(), newName));
                    }
                    ++i;
                }
                if (node.hasAttributes()) {
                    String attributeNameStart = "p:";
                    String optionalAttributeNameEnd = "-ref";
                    NamedNodeMap attributes = node.getAttributes();
                    int attributeCount = attributes.getLength();
                    int i2 = 0;
                    while (i2 < attributeCount) {
                        List types;
                        AttrImpl attribute = (AttrImpl)attributes.item(i2);
                        String attributeName = attribute.getNodeName();
                        if (attributeName != null && attributeName.startsWith(attributeNameStart) && (attributeName.equals(String.valueOf(attributeNameStart) + methodName) || attributeName.equals(String.valueOf(attributeNameStart) + methodName + optionalAttributeNameEnd)) && (types = BeansEditorUtils.getClassNamesOfBean((IFile)file, (Node)node)).contains(((IMethod)element).getDeclaringType())) {
                            int offset = attribute.getNameRegionStartOffset() + attributeNameStart.length();
                            result.add((TextEdit)new ReplaceEdit(offset, methodName.length(), newName));
                        }
                        ++i2;
                    }
                }
            } else {
                TextEdit edit = null;
                edit = BeansRefactoringChangeUtils.createMethodTextEditForAttribute(node, element, newName, file, "init-method");
                if (edit != null) {
                    result.add(edit);
                }
                if ((edit = BeansRefactoringChangeUtils.createMethodTextEditForAttribute(node, element, newName, file, "destroy-method")) != null) {
                    result.add(edit);
                }
                if ((edit = BeansRefactoringChangeUtils.createMethodTextEditForAttribute(node, element, newName, file, "factory-method")) != null) {
                    result.add(edit);
                }
            }
        }
        return result;
    }

    private static TextEdit createMethodTextEditForAttribute(Node node, IJavaElement element, String newName, IFile file, String attrName) {
        AttrImpl attr;
        int offset;
        List types;
        String attrMethodName;
        String methodName = element.getElementName();
        if (BeansEditorUtils.hasAttribute((Node)node, (String)attrName) && methodName.equals(attrMethodName = BeansEditorUtils.getAttribute((Node)node, (String)attrName)) && (types = BeansEditorUtils.getClassNamesOfBean((IFile)file, (Node)node)).contains(((IMethod)element).getDeclaringType()) && (offset = (attr = (AttrImpl)node.getAttributes().getNamedItem(attrName)).getValueRegionStartOffset() + 1) >= 0) {
            return new ReplaceEdit(offset, attrMethodName.length(), newName);
        }
        return null;
    }

    public static Change createRenameBeanIdChange(IFile file, RenameIdType descriptor, String oldBeanId, String newBeanId, boolean updateReferences, IProgressMonitor monitor) throws CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model == null) {
                return null;
            }
            IDOMDocument document = ((DOMModelImpl)model).getDocument();
            MultiTextEdit multiEdit = new MultiTextEdit();
            NodeList nodes = document.getElementsByTagNameNS(descriptor.getElementNamespaceURI(), descriptor.getElementName());
            int i = 0;
            while (i < nodes.getLength()) {
                TextEdit edit = BeansRefactoringChangeUtils.createRenameBeanIdTextEdit(nodes.item(i), oldBeanId, newBeanId);
                if (edit != null) {
                    multiEdit.addChild(edit);
                }
                ++i;
            }
            if (model != null) {
                model.releaseFromRead();
                model = null;
            }
            TextFileChange refChanges = null;
            if (updateReferences) {
                refChanges = BeansRefactoringChangeUtils.createRenameBeanRefsChange(file, descriptor, oldBeanId, newBeanId, monitor);
            }
            if (multiEdit.hasChildren()) {
                MultiTextEdit edit;
                TextFileChange change = new TextFileChange("", file);
                change.setEdit((TextEdit)multiEdit);
                TextEdit[] textEditArray = multiEdit.getChildren();
                int n = textEditArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit e = textEditArray[n2];
                    change.addTextEditGroup(new TextEditGroup("Rename " + descriptor.getType() + " id", e));
                    ++n2;
                }
                if (refChanges != null && (edit = (MultiTextEdit)refChanges.getEdit()).hasChildren()) {
                    TextEdit[] textEditArray2 = edit.getChildren();
                    int n3 = textEditArray2.length;
                    n = 0;
                    while (n < n3) {
                        TextEdit e = textEditArray2[n];
                        edit.removeChild(e);
                        multiEdit.addChild(e);
                        change.addTextEditGroup(new TextEditGroup("Rename " + descriptor.getType() + " reference", e));
                        ++n;
                    }
                }
                TextFileChange textFileChange = change;
                return textFileChange;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private static TextEdit createRenameBeanIdTextEdit(Node node, String oldBeanId, String newBeanId) {
        AttrImpl attr;
        int offset;
        if (node == null) {
            return null;
        }
        String id = BeansEditorUtils.getAttribute((Node)node, (String)"id");
        if (oldBeanId.equals(id) && (offset = (attr = (AttrImpl)node.getAttributes().getNamedItem("id")).getValueRegionStartOffset() + 1) >= 0) {
            return new ReplaceEdit(offset, oldBeanId.length(), newBeanId);
        }
        return null;
    }

    public static TextFileChange createRenameBeanRefsChange(IFile file, String oldBeanId, String newBeanId, IProgressMonitor monitor) throws CoreException {
        RenameIdType descriptor = RenameIdType.BEAN;
        return BeansRefactoringChangeUtils.createRenameBeanRefsChange(file, descriptor, oldBeanId, newBeanId, monitor);
    }

    public static TextFileChange createRenameBeanRefsChange(IFile file, RenameIdType descriptor, String oldBeanId, String newBeanId, IProgressMonitor monitor) throws CoreException {
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model == null) {
                return null;
            }
            IDOMDocument document = ((DOMModelImpl)model).getDocument();
            MultiTextEdit multiEdit = new MultiTextEdit();
            NodeList nodes = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                BeansRefactoringChangeUtils.createRenameBeanRefsTextEdit(nodes.item(i), descriptor, oldBeanId, newBeanId, multiEdit);
                ++i;
            }
            if (multiEdit.hasChildren()) {
                TextFileChange change = new TextFileChange("", file);
                change.setEdit((TextEdit)multiEdit);
                TextEdit[] textEditArray = multiEdit.getChildren();
                int n = textEditArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEdit e = textEditArray[n2];
                    change.addTextEditGroup(new TextEditGroup("Rename " + descriptor.getType() + " reference", e));
                    ++n2;
                }
                TextFileChange textFileChange = change;
                return textFileChange;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    private static void createRenameBeanRefsTextEdit(Node node, RenameIdType descriptor, String oldBeanId, String newBeanId, MultiTextEdit multiEdit) {
        NodeList nodes;
        String[] attributeNames;
        if (node == null) {
            return;
        }
        String[] stringArray = attributeNames = descriptor.getReferenceAttributeNames();
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String attributeName = stringArray[n2];
            BeansRefactoringChangeUtils.createRenameBeanRefTextEditForAttribute(attributeName, node, oldBeanId, newBeanId, multiEdit);
            ++n2;
        }
        String[] attributeNameStarts = descriptor.getReferenceAttributeStarts();
        String[] attributeNameEnds = descriptor.getReferenceAttributeEnds();
        if (attributeNameStarts != null && attributeNameEnds != null && attributeNameStarts.length == attributeNameEnds.length) {
            int i = 0;
            while (i < attributeNameStarts.length) {
                String attributeStart = attributeNameStarts[i];
                String attributeEnd = attributeNameEnds[i];
                BeansRefactoringChangeUtils.createRenameBeanRefTextEditForAttribute(attributeStart, attributeEnd, node, oldBeanId, newBeanId, multiEdit);
                ++i;
            }
        }
        if ((nodes = node.getChildNodes()) != null && nodes.getLength() > 0) {
            int i = 0;
            while (i < nodes.getLength()) {
                BeansRefactoringChangeUtils.createRenameBeanRefsTextEdit(nodes.item(i), descriptor, oldBeanId, newBeanId, multiEdit);
                ++i;
            }
        }
    }

    private static void createRenameBeanRefTextEditForAttribute(String attributeNameStart, String attributeNameEnd, Node node, String oldBeanId, String newBeanId, MultiTextEdit multiEdit) {
        if (!node.hasAttributes()) {
            return;
        }
        NamedNodeMap attributes = node.getAttributes();
        int attributeCount = attributes.getLength();
        int i = 0;
        while (i < attributeCount) {
            int offset;
            String beanRef;
            Node attribute = attributes.item(i);
            String attributeName = attribute.getNodeName();
            if (attributeName != null && attributeName.startsWith(attributeNameStart) && attributeName.endsWith(attributeNameEnd) && (beanRef = attribute.getNodeValue()) != null && beanRef.equals(oldBeanId) && (offset = ((AttrImpl)attribute).getValueRegionStartOffset() + 1) >= 0) {
                multiEdit.addChild((TextEdit)new ReplaceEdit(offset, beanRef.length(), newBeanId));
            }
            ++i;
        }
    }

    private static void createRenameBeanRefTextEditForAttribute(String attributeName, Node node, String oldBeanId, String newBeanId, MultiTextEdit multiEdit) {
        AttrImpl attr;
        int offset;
        String beanRef;
        if (BeansEditorUtils.hasAttribute((Node)node, (String)attributeName) && (beanRef = BeansEditorUtils.getAttribute((Node)node, (String)attributeName)) != null && beanRef.equals(oldBeanId) && (offset = (attr = (AttrImpl)node.getAttributes().getNamedItem(attributeName)).getValueRegionStartOffset() + 1) >= 0) {
            multiEdit.addChild((TextEdit)new ReplaceEdit(offset, beanRef.length(), newBeanId));
        }
    }

    public static void createRenameChange(TextChange textChange, TextEdit textEdit, IFile file, IJavaElement[] affectedElements, String[] newNames, IProgressMonitor monitor) throws CoreException {
        IJavaProject jp = JdtUtils.getJavaProject((IProject)file.getProject());
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForRead(file);
            if (model == null) {
                return;
            }
            try {
                IDOMDocument document = ((DOMModelImpl)model).getDocument();
                NodeList nodes = document.getChildNodes();
                int j = 0;
                while (j < affectedElements.length) {
                    IJavaElement je = affectedElements[j];
                    if (jp == null || jp != null && jp.isOnClasspath(je)) {
                        int i = 0;
                        while (i < nodes.getLength()) {
                            Node n = nodes.item(i);
                            BeansRefactoringChangeUtils.recursiveCreateTextEdit(newNames[j], textChange, textEdit, je, n);
                            ++i;
                        }
                    }
                    ++j;
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private static void recursiveCreateTextEdit(String newName, TextChange textChange, TextEdit textEdit, IJavaElement je, Node n) {
        BeansRefactoringChangeUtils.createTextEdit(n, je, newName, textChange, textEdit);
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            BeansRefactoringChangeUtils.recursiveCreateTextEdit(newName, textChange, textEdit, je, children.item(i));
            ++i;
        }
    }

    private static void createTextEdit(Node node, IJavaElement element, String newName, TextChange textChange, TextEdit textEdit) {
        int offset;
        String value;
        if (node == null) {
            return;
        }
        String oldName = element instanceof IType ? ((IType)element).getFullyQualifiedName('$') : element.getElementName();
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                AttrImpl attr;
                int offset2;
                String attribute = attributes.item(i).getNodeValue();
                if ((oldName.equals(attribute) || BeansRefactoringChangeUtils.isGoodMatch(attribute, oldName, element instanceof IPackageFragment)) && (offset2 = (attr = (AttrImpl)attributes.getNamedItem(attributes.item(i).getNodeName())).getValueRegionStartOffset() + 1) >= 0) {
                    ReplaceEdit edit = new ReplaceEdit(offset2, oldName.length(), newName);
                    textEdit.addChild((TextEdit)edit);
                    textChange.addTextEditGroup(new TextEditGroup("Update class reference", (TextEdit)edit));
                }
                ++i;
            }
        }
        if (node instanceof TextImpl && (value = node.getNodeValue()) != null && (oldName.equals(value) || BeansRefactoringChangeUtils.isGoodMatch(value, oldName, element instanceof IPackageFragment)) && (offset = ((TextImpl)node).getStartOffset()) >= 0) {
            ReplaceEdit edit = new ReplaceEdit(offset, oldName.length(), newName);
            textEdit.addChild((TextEdit)edit);
            textChange.addTextEditGroup(new TextEditGroup("Update class reference", (TextEdit)edit));
        }
    }

    private static boolean isGoodMatch(String value, String oldName, boolean isPackage) {
        boolean goodLengthMatch;
        if (value == null || value.length() <= oldName.length()) {
            return false;
        }
        boolean bl = isPackage ? value.lastIndexOf(46) <= oldName.length() : (goodLengthMatch = value.charAt(oldName.length()) == '$');
        return value.startsWith(oldName) && goodLengthMatch;
    }
}

