/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.core.internal.commands;

import java.util.ArrayList;
import java.util.List;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameterDescriptor;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IParameterValueListener;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.IValueChangedNotifier;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ParameterValueEvent;

public class CommandParameter
implements ICommandParameter,
IValueChangedNotifier {
    private Object value;
    private ICommandParameterDescriptor descriptor;
    private List<IParameterValueListener> listeners;

    public CommandParameter(ICommandParameterDescriptor descriptor) {
        this.descriptor = descriptor;
        this.init();
    }

    protected void init() {
        Object defaultValue;
        if (this.descriptor != null && (defaultValue = this.descriptor.getDefaultValue()) != null) {
            this.value = defaultValue;
        }
    }

    @Override
    public ICommandParameterDescriptor getParameterDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
        this.notifyValueChanged(value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public IParameterValueListener addListener(IParameterValueListener listener) {
        if (listener == null) {
            return null;
        }
        if (this.listeners != null) {
            this.listeners = new ArrayList<IParameterValueListener>();
        }
        if (this.listeners.contains(listener)) {
            return null;
        }
        this.listeners.add(listener);
        return listener;
    }

    @Override
    public IParameterValueListener removeListener(IParameterValueListener listener) {
        if (this.listeners != null && this.listeners.remove(listener)) {
            return listener;
        }
        return null;
    }

    protected void notifyValueChanged(Object value) {
        if (this.listeners == null) {
            return;
        }
        ParameterValueEvent event = new ParameterValueEvent(value);
        for (IParameterValueListener listener : this.listeners) {
            listener.handleValueChanged(event);
        }
    }
}

