/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model.validation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.java.typehierarchy.TypeHierarchyEngine;

public class BeansTypeHierachyState {
    private Map<IResource, Set<IBean>> beansByType = new ConcurrentHashMap<IResource, Set<IBean>>();
    private Map<IResource, Set<IBeansConfig>> configsByType = new ConcurrentHashMap<IResource, Set<IBeansConfig>>();
    private TypeHierarchyEngine typeEngine = null;

    public BeansTypeHierachyState(TypeHierarchyEngine typeEngine) {
        this.typeEngine = typeEngine;
    }

    public Set<IBean> getBeansByContainingTypes(IResource resource) {
        if (!this.beansByType.containsKey(resource)) {
            this.beansByType.put(resource, BeansModelUtils.getBeansByContainingTypes(resource, this.typeEngine, (IProgressMonitor)new NullProgressMonitor()));
        }
        return this.beansByType.get(resource);
    }

    public Set<IBeansConfig> getConfigsByContainingTypes(IResource resource) {
        if (!this.configsByType.containsKey(resource)) {
            this.configsByType.put(resource, BeansModelUtils.getConfigsByContainingTypes(resource, this.typeEngine, (IProgressMonitor)new NullProgressMonitor()));
        }
        return this.configsByType.get(resource);
    }
}

