/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;

public class BeansCoreUtils {
    public static final ISchedulingRule BEANS_MODEL_INIT_RULE = BeansCoreUtils.lightRule("Beans Model Initialization");

    public static boolean isBeansConfig(IResource resource) {
        return BeansCoreUtils.isBeansConfig(resource, true);
    }

    public static boolean isBeansConfig(IResource resource, boolean includeImported) {
        if (resource instanceof IFile) {
            return BeansCorePlugin.getModel().isConfig((IFile)resource, includeImported);
        }
        return false;
    }

    private static ISchedulingRule lightRule(final String name) {
        return new ISchedulingRule(){

            public boolean contains(ISchedulingRule rule) {
                return rule == this;
            }

            public boolean isConflicting(ISchedulingRule rule) {
                return rule == this || rule.contains((ISchedulingRule)this);
            }

            public String toString() {
                return name;
            }
        };
    }
}

