/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.TypeText;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.EditorUsageMode;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.RulePropertyManager;
import net.sourceforge.pmd.eclipse.util.ColourManager;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRulePanelManager
extends WizardPage
implements RulePropertyManager {
    private TabItem tab;
    private String tabText;
    private boolean isActive;
    protected RuleSelection rules;
    protected final ValueChangeListener changeListener;
    private final EditorUsageMode usageMode;
    protected static Color textColour;
    protected static Color errorColour;
    protected static Color disabledColour;
    protected static Color overridenColour;
    private static final String disabledTabText = "-------";
    public static final RGB overridenColourValues;

    static {
        overridenColourValues = new RGB(236, 236, 255);
    }

    public AbstractRulePanelManager(String theId, String theTitle, EditorUsageMode theMode, ValueChangeListener theListener) {
        super(theId, theTitle, null);
        this.changeListener = theListener;
        this.usageMode = theMode;
    }

    public abstract Control setupOn(Composite var1);

    public EditorUsageMode mode() {
        return this.usageMode;
    }

    public void createControl(Composite panel) {
        Control childPanel = this.setupOn(panel);
        this.setControl(childPanel);
        this.setPageComplete(true);
    }

    protected boolean creatingNewRule() {
        return this.usageMode == EditorUsageMode.CreateNew;
    }

    @Override
    public void tab(TabItem theTab) {
        this.tab = theTab;
        this.tabText = theTab.getText();
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    protected String asCleanString(String original) {
        if (original == null) {
            return "";
        }
        return original.trim();
    }

    @Override
    public void manage(RuleSelection theRules) {
        this.rules = theRules;
        this.isActive = this.rules.hasOneRule() && this.canWorkWith(this.rules.soleRule()) || this.rules.hasMultipleRules() && this.canManageMultipleRules();
        this.showControls(this.isActive);
        if (this.tab != null) {
            this.tab.setText(this.isActive ? this.tabText : disabledTabText);
        }
        if (this.isActive) {
            this.adapt();
        } else {
            this.clearControls();
        }
        this.updateUI();
    }

    protected void valueChanged(PropertyDescriptor<?> optionalDesc, Object newValue) {
        this.changeListener.changed(this.rules, optionalDesc, newValue);
        this.updateUI();
    }

    protected void updateUI() {
        List<String> warnings = this.fieldWarnings();
        List<String> errors = this.fieldErrors();
        if (this.tab != null) {
            this.updateTabUI(warnings, errors);
        }
        this.updateOverridenFields();
        this.disableIrrelevantFields();
    }

    protected void updateOverridenFields() {
    }

    protected void disableIrrelevantFields() {
    }

    protected boolean canWorkWith(Rule rule) {
        return true;
    }

    protected List<String> fieldErrors() {
        return Collections.emptyList();
    }

    protected List<String> fieldWarnings() {
        return Collections.emptyList();
    }

    @Override
    public boolean validate() {
        List<String> warnings = this.fieldWarnings();
        List<String> errors = this.fieldErrors();
        if (this.tab != null) {
            this.updateTabUI(warnings, errors);
        }
        String errorText = errors.isEmpty() ? null : StringUtil.asString((Object[])errors.toArray(), (String)", ");
        this.setErrorMessage(errorText);
        this.setPageComplete(StringUtil.isEmpty((String)errorText));
        return errorText == null;
    }

    protected void updateTabUI(List<String> warnings, List<String> errors) {
        if (!this.isActive) {
            this.tab.setToolTipText("");
            this.tab.setImage(null);
            return;
        }
        boolean hasIssues = this.updateTab(errors, "icons/error.gif");
        if (hasIssues) {
            return;
        }
        this.updateTab(this.fieldWarnings(), "icons/warn.gif");
    }

    private boolean updateTab(List<String> issues, String iconName) {
        boolean hasIssues = !issues.isEmpty();
        this.tab.setImage(hasIssues ? ResourceManager.imageFor(iconName) : null);
        this.tab.setToolTipText(hasIssues ? issues.toString() : "");
        return hasIssues;
    }

    protected abstract boolean canManageMultipleRules();

    protected abstract void adapt();

    protected abstract void clearControls();

    public abstract void showControls(boolean var1);

    protected Rule soleRule() {
        return this.rules.soleRule();
    }

    protected void addTextListeners(final Text control, final StringProperty desc) {
        control.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                AbstractRulePanelManager.this.changed(desc, control.getText());
            }
        });
    }

    protected void addTextListeners(final StyledText control, final StringProperty desc) {
        control.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                AbstractRulePanelManager.this.changed(desc, control.getText());
            }
        });
    }

    @Override
    public void loadValues() {
    }

    protected void initializeOn(Composite parent) {
        if (errorColour != null) {
            return;
        }
        ColourManager clrMgr = ColourManager.managerFor(parent.getDisplay());
        errorColour = clrMgr.colourFor(new RGB(255, 0, 0));
        textColour = clrMgr.colourFor(new RGB(0, 0, 0));
        disabledColour = clrMgr.colourFor(new RGB(128, 128, 128));
    }

    protected void changed(StringProperty property, String newValue) {
        if (this.rules == null) {
            return;
        }
        String cleanValue = newValue.trim();
        String existingValue = this.rules.commonStringValue(property);
        if (StringUtil.areSemanticEquals((String)existingValue, (String)cleanValue)) {
            return;
        }
        this.rules.setValue(property, cleanValue);
        this.valueChanged((PropertyDescriptor<?>)property, newValue);
    }

    protected void shutdown(Text control) {
        control.setText("");
        control.setEnabled(false);
    }

    protected void shutdown(StyledText control) {
        control.setText("");
        control.setEnabled(false);
    }

    protected void shutdown(Link control) {
        control.setText("");
        control.setEnabled(false);
    }

    protected void show(TypeText control, Class<?> type) {
        control.setType(type);
    }

    protected void show(Button checkbox, boolean checked) {
        checkbox.setSelection(checked);
    }

    protected void show(Text control, String value) {
        control.setText(value == null ? "" : value);
    }

    protected void show(StyledText control, String value) {
        control.setText(value == null ? "" : value);
    }

    protected void show(Combo control, String value) {
        if (StringUtil.isEmpty((String)value)) {
            control.deselectAll();
            return;
        }
        String[] choices = control.getItems();
        int index = -1;
        int i = 0;
        while (i < choices.length) {
            if (StringUtil.areSemanticEquals((String)choices[i], (String)value)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            control.deselectAll();
        } else {
            control.select(index);
        }
    }

    protected void show(CCombo control, String value) {
        if (StringUtil.isEmpty((String)value)) {
            control.deselectAll();
            return;
        }
        String[] choices = control.getItems();
        int index = -1;
        int i = 0;
        while (i < choices.length) {
            if (StringUtil.areSemanticEquals((String)choices[i], (String)value)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index < 0) {
            control.deselectAll();
        } else {
            control.select(index);
        }
    }

    protected void show(Link control, String value) {
        control.setText(value == null ? "" : value);
    }

    protected Text newTextField(Composite parent) {
        return new Text(parent, 2882);
    }

    protected StyledText newCodeField(Composite parent) {
        StyledText st = new StyledText(parent, 2816);
        return st;
    }
}

