/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractMultiValueEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.EnumerationEditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.lang.rule.properties.EnumeratedMultiProperty;
import net.sourceforge.pmd.lang.rule.properties.PropertyDescriptorWrapper;
import net.sourceforge.pmd.util.CollectionUtil;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiEnumerationEditorFactory
extends AbstractMultiValueEditorFactory {
    public static final MultiEnumerationEditorFactory instance = new MultiEnumerationEditorFactory();

    private MultiEnumerationEditorFactory() {
    }

    private static EnumeratedMultiProperty<?> enumerationPropertyFrom(PropertyDescriptor<?> desc) {
        if (desc instanceof PropertyDescriptorWrapper) {
            return (EnumeratedMultiProperty)((PropertyDescriptorWrapper)desc).getPropertyDescriptor();
        }
        return (EnumeratedMultiProperty)desc;
    }

    @Override
    protected Object addValueIn(Control widget, PropertyDescriptor<?> desc, PropertySource source) {
        String[] newValues;
        int idx = ((Combo)widget).getSelectionIndex();
        if (idx < 0) {
            return null;
        }
        String newValue = ((Combo)widget).getItem(idx);
        Object[] currentValues = (String[])this.valueFor(source, desc);
        if (currentValues.length == (newValues = (String[])CollectionUtil.addWithoutDuplicates((Object[])currentValues, (Object)newValue)).length) {
            return null;
        }
        source.setProperty((PropertyDescriptor)((EnumeratedMultiProperty)desc), (Object)newValues);
        return newValue;
    }

    @Override
    protected boolean canAddNewRowFor(PropertyDescriptor<?> desc, PropertySource source) {
        Object[] values;
        Object[][] choices = desc.choices();
        return choices.length > (values = (Object[])source.getProperty(desc)).length;
    }

    @Override
    protected Control addWidget(Composite parent, Object value, PropertyDescriptor<?> desc, PropertySource source) {
        Combo combo = new Combo(parent, 8);
        EnumeratedMultiProperty<?> ep = MultiEnumerationEditorFactory.enumerationPropertyFrom(desc);
        combo.setItems(SWTUtil.labelsIn(ep.choices(), 0));
        int selectionIdx = EnumerationEditorFactory.indexOf(value, ep.choices());
        if (selectionIdx >= 0) {
            combo.select(selectionIdx);
        }
        return combo;
    }

    @Override
    protected void setValue(Control widget, Object value) {
    }

    @Override
    protected void update(PropertySource source, PropertyDescriptor<?> desc, List<Object> newValues) {
        source.setProperty((PropertyDescriptor)((EnumeratedMultiProperty)desc), (Object)newValues.toArray(new String[newValues.size()]));
    }

    @Override
    protected Object valueFrom(Control valueControl) {
        return null;
    }

    @Override
    public PropertyDescriptor<?> createDescriptor(String name, String description, Control[] otherData) {
        return null;
    }

    @Override
    protected void configure(Text text, PropertyDescriptor<?> desc, PropertySource source, ValueChangeListener listener) {
        text.setEditable(false);
    }
}

