/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.namespaces;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.INamespaceDefinitionResolver;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.namespaces.DefaultNamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.DisplayThreadImageAccessor;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceDefinition;
import org.springframework.ide.eclipse.beans.ui.namespaces.INamespaceLabelProvider;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelUtils;
import org.springframework.util.StringUtils;

public class NamespaceUtils {
    public static final String NAMESPACES_EXTENSION_POINT = "org.springframework.ide.eclipse.beans.ui.namespaces";
    public static final String DEFAULT_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String TOOLS_NAMESPACE_URI = "http://www.springframework.org/schema/tool";
    public static final String P_NAMESPACE_URI = "http://www.springframework.org/schema/p";
    public static final String C_NAMESPACE_URI = "http://www.springframework.org/schema/c";
    private static final Object IMAGE_REGISTRY_LOCK = new Object();
    private static final INamespaceDefinition P_NAMESPACE_DEFINITION = new DefaultNamespaceDefinition("p", "http://www.springframework.org/schema/p", null, new DefaultImageAccessor("org.springframework.ide.eclipse.beans.ui", "/icons/full/obj16/property_obj.gif"));
    private static final INamespaceDefinition C_NAMESPACE_DEFINITION = new DefaultNamespaceDefinition("c", "http://www.springframework.org/schema/c", null, new DefaultImageAccessor("org.springframework.ide.eclipse.beans.ui", "/icons/full/obj16/constructor_obj.gif"));

    public static String getNameSpaceURI(ISourceModelElement element) {
        String namespaceURI = ModelUtils.getNameSpaceURI((ISourceModelElement)element);
        if (namespaceURI == null) {
            namespaceURI = DEFAULT_NAMESPACE_URI;
        }
        return namespaceURI;
    }

    public static INamespaceLabelProvider getLabelProvider(ISourceModelElement element) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
        if (point != null) {
            String namespaceURI = NamespaceUtils.getNameSpaceURI(element);
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (namespaceURI.equals(config.getAttribute("uri"))) {
                        if (config.getAttribute("labelProvider") != null) {
                            try {
                                Object provider = config.createExecutableExtension("labelProvider");
                                if (provider instanceof INamespaceLabelProvider) {
                                    return (INamespaceLabelProvider)provider;
                                }
                            }
                            catch (CoreException e) {
                                BeansUIPlugin.log(e);
                            }
                        }
                        return null;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ITreeContentProvider getContentProvider(ISourceModelElement element) {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
        if (point != null) {
            String namespaceURI = NamespaceUtils.getNameSpaceURI(element);
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (namespaceURI.equals(config.getAttribute("uri"))) {
                        if (config.getAttribute("contentProvider") != null) {
                            try {
                                Object provider = config.createExecutableExtension("contentProvider");
                                if (provider instanceof IContentProvider) {
                                    return (ITreeContentProvider)provider;
                                }
                            }
                            catch (CoreException e) {
                                BeansUIPlugin.log(e);
                            }
                        }
                        return null;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<INamespaceDefinition> getNamespaceDefinitions() {
        return NamespaceUtils.getNamespaceDefinitions(null);
    }

    public static List<INamespaceDefinition> getNamespaceDefinitions(final IProject project, final INamespaceDefinitionTemplate definitionTemplate) {
        if (definitionTemplate != null) {
            Job namespaceDefinitionJob = new Job(project != null ? String.format("Loading namespaces for project '%s'", project.getName()) : "Loading namespaces"){

                protected IStatus run(IProgressMonitor monitor) {
                    List<INamespaceDefinition> namespaceDefinitions = NamespaceUtils.getNamespaceDefinitions(project);
                    definitionTemplate.doWithNamespaceDefinitions(namespaceDefinitions.toArray(new INamespaceDefinition[namespaceDefinitions.size()]), project);
                    return Status.OK_STATUS;
                }
            };
            namespaceDefinitionJob.setPriority(10);
            namespaceDefinitionJob.schedule();
            return Collections.emptyList();
        }
        return NamespaceUtils.getNamespaceDefinitions(project);
    }

    protected static List<INamespaceDefinition> getNamespaceDefinitions(IProject project) {
        ArrayList<INamespaceDefinition> namespaceDefinitions = new ArrayList<INamespaceDefinition>();
        INamespaceDefinitionResolver definitionResolver = BeansCorePlugin.getNamespaceDefinitionResolver((IProject)project);
        Set detectedNamespaceDefinitions = definitionResolver.getNamespaceDefinitions();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
        if (point != null && !org.springframework.ide.eclipse.beans.core.namespaces.NamespaceUtils.useNamespacesFromClasspath((IProject)project)) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement[] schemaLocationConfigElements;
                    String schemaLocation;
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String uri = config.getAttribute("uri");
                    org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition namespaceDefinition = definitionResolver.resolveNamespaceDefinition(uri);
                    detectedNamespaceDefinitions.remove(namespaceDefinition);
                    String prefix = config.getAttribute("prefix");
                    if (!StringUtils.hasText((String)prefix) && namespaceDefinition != null) {
                        prefix = namespaceDefinition.getPrefix();
                    }
                    if (!StringUtils.hasText((String)(schemaLocation = config.getAttribute("defaultSchemaLocation"))) && namespaceDefinition != null) {
                        schemaLocation = namespaceDefinition.getDefaultSchemaLocation();
                    }
                    DisplayThreadImageAccessor image = null;
                    if (config.getAttribute("icon") != null) {
                        String ns = config.getDeclaringExtension().getNamespaceIdentifier();
                        String icon = config.getAttribute("icon");
                        image = new DefaultImageAccessor(ns, icon);
                    } else if (namespaceDefinition != null) {
                        image = new NamespaceDefinitionImageAccessor(namespaceDefinition);
                    }
                    DefaultNamespaceDefinition def = null;
                    def = namespaceDefinition != null ? new DefaultNamespaceDefinition(prefix, uri, schemaLocation, namespaceDefinition.getUriMapping(), image) : new DefaultNamespaceDefinition(prefix, uri, schemaLocation, new Properties(), image);
                    IConfigurationElement[] iConfigurationElementArray2 = schemaLocationConfigElements = config.getChildren("schemaLocation");
                    int n5 = schemaLocationConfigElements.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement schemaLocationConfigElement = iConfigurationElementArray2[n6];
                        def.addSchemaLocation(schemaLocationConfigElement.getAttribute("url"));
                        ++n6;
                    }
                    if (def.getSchemaLocations().size() == 0 && namespaceDefinition != null) {
                        def.getSchemaLocations().addAll(namespaceDefinition.getSchemaLocations());
                    }
                    namespaceDefinitions.add(def);
                    ++n4;
                }
                ++n2;
            }
        }
        for (org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition namespaceDefinition : detectedNamespaceDefinitions) {
            DefaultNamespaceDefinition def = new DefaultNamespaceDefinition(namespaceDefinition.getPrefix(), namespaceDefinition.getNamespaceUri(), namespaceDefinition.getDefaultSchemaLocation(), namespaceDefinition.getUriMapping(), new NamespaceDefinitionImageAccessor(namespaceDefinition));
            def.getSchemaLocations().addAll(namespaceDefinition.getSchemaLocations());
            namespaceDefinitions.add(def);
        }
        boolean foundPNamespace = false;
        boolean foundCNamespace = false;
        INamespaceDefinition defaultNamespace = null;
        for (INamespaceDefinition definition : new ArrayList(namespaceDefinitions)) {
            if (TOOLS_NAMESPACE_URI.equals(definition.getNamespaceURI())) {
                namespaceDefinitions.remove(definition);
                continue;
            }
            if (DEFAULT_NAMESPACE_URI.equals(definition.getNamespaceURI())) {
                defaultNamespace = definition;
                continue;
            }
            if (P_NAMESPACE_URI.equals(definition.getNamespaceURI())) {
                foundPNamespace = true;
                continue;
            }
            if (!C_NAMESPACE_URI.equals(definition.getNamespaceURI())) continue;
            foundCNamespace = true;
        }
        if (!foundPNamespace && defaultNamespace != null) {
            namespaceDefinitions.add(P_NAMESPACE_DEFINITION);
        }
        if (!foundCNamespace && defaultNamespace != null) {
            Set<String> locations = defaultNamespace.getSchemaLocations();
            for (String locationUri : locations) {
                if (!NamespaceUtils.isSpring31(locationUri)) continue;
                namespaceDefinitions.add(C_NAMESPACE_DEFINITION);
                break;
            }
        }
        Collections.sort(namespaceDefinitions, new Comparator<INamespaceDefinition>(){

            @Override
            public int compare(INamespaceDefinition o1, INamespaceDefinition o2) {
                if (o1 != null && o1.getDefaultNamespacePrefix() != null && o2 != null && o2.getDefaultNamespacePrefix() != null) {
                    return o1.getDefaultNamespacePrefix().compareTo(o2.getDefaultNamespacePrefix());
                }
                return 0;
            }
        });
        return namespaceDefinitions;
    }

    private static boolean isSpring31(String locationUri) {
        DefaultNamespaceDefinition.Version minimum = new DefaultNamespaceDefinition.Version("3.1");
        DefaultNamespaceDefinition.Version temp = DefaultNamespaceDefinition.Version.MINIMUM_VERSION;
        Matcher matcher = DefaultNamespaceDefinition.VERSION_PATTERN.matcher(locationUri);
        if (matcher.matches()) {
            temp = new DefaultNamespaceDefinition.Version(matcher.group(1));
        }
        return temp.compareTo(minimum) >= 0;
    }

    public static INamespaceDefinition getDefaultNamespaceDefinition() {
        INamespaceDefinitionResolver definitionResolver = BeansCorePlugin.getNamespaceDefinitionResolver(null);
        org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition namespaceDefinition = definitionResolver.resolveNamespaceDefinition(DEFAULT_NAMESPACE_URI);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACES_EXTENSION_POINT);
        if (point != null) {
            String namespaceURI = DEFAULT_NAMESPACE_URI;
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    if (namespaceURI.equals(config.getAttribute("uri"))) {
                        String schemaLocation;
                        String prefix = config.getAttribute("prefix");
                        if (!StringUtils.hasText((String)prefix) && namespaceDefinition != null) {
                            prefix = namespaceDefinition.getPrefix();
                        }
                        if (!StringUtils.hasText((String)(schemaLocation = config.getAttribute("defaultSchemaLocation"))) && namespaceDefinition != null) {
                            schemaLocation = namespaceDefinition.getDefaultSchemaLocation();
                        }
                        String uri = config.getAttribute("uri");
                        DisplayThreadImageAccessor image = null;
                        if (config.getAttribute("icon") != null) {
                            String ns = config.getDeclaringExtension().getNamespaceIdentifier();
                            String icon = config.getAttribute("icon");
                            image = new DefaultImageAccessor(ns, icon);
                        } else if (namespaceDefinition != null) {
                            image = new NamespaceDefinitionImageAccessor(namespaceDefinition);
                        }
                        return new DefaultNamespaceDefinition(prefix, uri, schemaLocation, namespaceDefinition.getUriMapping(), image);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (namespaceDefinition != null) {
            return new DefaultNamespaceDefinition(namespaceDefinition.getPrefix(), namespaceDefinition.getNamespaceUri(), namespaceDefinition.getDefaultSchemaLocation(), namespaceDefinition.getUriMapping(), new NamespaceDefinitionImageAccessor(namespaceDefinition));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getImage(org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition namespaceDefinition) {
        if (!StringUtils.hasText((String)namespaceDefinition.getIconPath())) return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
        Object object = IMAGE_REGISTRY_LOCK;
        synchronized (object) {
            Image image = BeansUIPlugin.getDefault().getImageRegistry().get(namespaceDefinition.getIconPath());
            if (image != null) return image;
            InputStream is = namespaceDefinition.getIconStream();
            if (is != null) {
                try {
                    try {
                        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImageData((ImageData)new ImageData(is));
                        BeansUIPlugin.getDefault().getImageRegistry().put(namespaceDefinition.getIconPath(), imageDescriptor);
                        image = BeansUIPlugin.getDefault().getImageRegistry().get(namespaceDefinition.getIconPath());
                    }
                    catch (Exception e) {
                        BeansUIPlugin.log(String.format("Error creating image resource for namespace definition '%s'", namespaceDefinition.getNamespaceUri()), e);
                        Image image2 = BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
                        if (is == null) return image2;
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                        return image2;
                    }
                }
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (is == null) return image;
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            } else {
                BeansUIPlugin.getDefault().getImageRegistry().put(namespaceDefinition.getIconPath(), BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif"));
                return BeansUIPlugin.getDefault().getImageRegistry().get(namespaceDefinition.getIconPath());
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getImage(String ns, String icon) {
        if (StringUtils.hasText((String)icon)) {
            Object object = IMAGE_REGISTRY_LOCK;
            synchronized (object) {
                Image image = BeansUIPlugin.getDefault().getImageRegistry().get(icon);
                if (image == null) {
                    ImageDescriptor imageDescriptor = BeansUIPlugin.imageDescriptorFromPlugin((String)ns, (String)icon);
                    BeansUIPlugin.getDefault().getImageRegistry().put(icon, imageDescriptor);
                    image = BeansUIPlugin.getDefault().getImageRegistry().get(icon);
                }
                return image;
            }
        }
        return BeansUIImages.getImage("org.springframework.ide.eclipse.beans.ui.xsd_obj.gif");
    }

    private static class DefaultImageAccessor
    extends DisplayThreadImageAccessor {
        private final String ns;
        private final String icon;

        public DefaultImageAccessor(String ns, String icon) {
            this.ns = ns;
            this.icon = icon;
        }

        @Override
        protected Image createImage() {
            return NamespaceUtils.getImage(this.ns, this.icon);
        }
    }

    public static interface INamespaceDefinitionTemplate {
        public void doWithNamespaceDefinitions(INamespaceDefinition[] var1, IProject var2);
    }

    private static class NamespaceDefinitionImageAccessor
    extends DisplayThreadImageAccessor {
        private final org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition definition;

        public NamespaceDefinitionImageAccessor(org.springframework.ide.eclipse.beans.core.model.INamespaceDefinition definition) {
            this.definition = definition;
        }

        @Override
        protected Image createImage() {
            return NamespaceUtils.getImage(this.definition);
        }
    }
}

