/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.namespaces;

import java.util.Collection;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IProfileAwareBeansComponent;
import org.springframework.ide.eclipse.beans.ui.BeansUILabels;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelLabels;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class BeansNamespaceLabels
extends BeansUILabels {
    public static String getElementLabel(ISourceModelElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        BeansNamespaceLabels.appendElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void appendElementLabel(ISourceModelElement element, int flags, StringBuffer buf) {
        if (BeansNamespaceLabels.isFlagged(flags, 1)) {
            BeansModelLabels.appendElementPathLabel((IModelElement)element, flags, buf);
            buf.append(" - ");
        }
        if (element instanceof IBean) {
            BeansNamespaceLabels.appendBeanLabel((IBean)element, buf);
        } else if (element instanceof IProfileAwareBeansComponent) {
            IProfileAwareBeansComponent component = (IProfileAwareBeansComponent)element;
            buf.append(element.getElementName());
            if (component.getProfiles() != null && component.getProfiles().size() > 0) {
                buf.append(" profiles=\"").append(StringUtils.collectionToDelimitedString((Collection)component.getProfiles(), (String)", ")).append("\"");
            }
        } else if (element instanceof ISourceModelElement) {
            BeansModelLabels.appendElementLabel((IModelElement)element, buf);
        } else if (element != null) {
            buf.append(element.getElementName());
        }
        if (BeansNamespaceLabels.isFlagged(flags, 2)) {
            buf.append(" - ");
            BeansModelLabels.appendElementPathLabel((IModelElement)element, flags, buf);
        }
    }

    public static void appendBeanLabel(IBean bean, StringBuffer buf) {
        if (!bean.isInnerBean()) {
            if (bean.isGeneratedElementName() && bean.getClassName() != null) {
                buf.append("<anonymous> ").append(ClassUtils.getShortName((String)bean.getClassName())).append(' ');
            } else if (bean.isGeneratedElementName() && bean.getClassName() == null) {
                buf.append("<anonymous> ");
            } else {
                buf.append(bean.getElementName()).append(' ');
                if (bean.getAliases() != null && bean.getAliases().length > 0) {
                    buf.append('\'');
                    buf.append(StringUtils.arrayToDelimitedString((Object[])bean.getAliases(), (String)", "));
                    buf.append("' ");
                }
            }
        }
        if (bean.getClassName() != null) {
            buf.append('[').append(bean.getClassName()).append(']');
        } else if (bean.getParentName() != null) {
            buf.append('<').append(bean.getParentName()).append('>');
        }
    }
}

