/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.dialogs.SubclipseTrayDialog;

public class QuestionDialog
extends SubclipseTrayDialog {
    private String realm;
    private String question;
    private boolean showAnswer;
    private boolean maySave;
    private Text answerText;
    private String answer;
    private boolean save;
    private Button saveButton;
    private boolean isPassphrasePrompt;
    private boolean isFilePrompt;
    private IDialogSettings settings = SVNUIPlugin.getPlugin().getDialogSettings();
    private static final int WIDTH = 300;

    public QuestionDialog(Shell parentShell, String realm, String question, boolean showAnswer, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.question = question;
        this.showAnswer = showAnswer;
        this.maySave = maySave;
        if (question != null) {
            boolean bl = this.isPassphrasePrompt = question.indexOf("certificate passphrase") != -1;
            if (!this.isPassphrasePrompt) {
                this.isFilePrompt = question.indexOf("certificate file") != -1;
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("SVNPromptUserPassword.authentication"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Group realmGroup = new Group(rtnGroup, 0);
        if (this.isPassphrasePrompt) {
            realmGroup.setText(Policy.bind("QuestionDialog.clientCertificateFile"));
        } else {
            realmGroup.setText(Policy.bind("PasswordPromptDialog.repository"));
        }
        GridLayout realmLayout = new GridLayout();
        realmLayout.numColumns = 1;
        realmGroup.setLayout((Layout)realmLayout);
        realmGroup.setLayoutData((Object)new GridData(32));
        Text realmText = new Text((Composite)realmGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = 300;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        Group questionGroup = new Group(rtnGroup, 0);
        questionGroup.setText(this.question);
        GridLayout questionLayout = new GridLayout();
        questionLayout.numColumns = 2;
        questionGroup.setLayout((Layout)questionLayout);
        questionGroup.setLayoutData((Object)new GridData(32));
        this.answerText = new Text((Composite)questionGroup, 2048);
        gd = new GridData();
        gd.widthHint = 300;
        this.answerText.setLayoutData((Object)gd);
        if (!this.showAnswer) {
            this.answerText.setEchoChar('*');
        }
        if (this.isFilePrompt) {
            String previousCertificateFile = null;
            try {
                previousCertificateFile = this.settings.get("QuestionDialog.certificateFile." + this.realm);
                if (previousCertificateFile != null) {
                    this.answerText.setText(previousCertificateFile);
                }
            }
            catch (Exception exception) {}
        }
        if (this.isFilePrompt) {
            Button browseButton = new Button((Composite)questionGroup, 8);
            browseButton.setText(Policy.bind("browse"));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog fileDialog = new FileDialog(QuestionDialog.this.getShell(), 4096);
                    fileDialog.setText("Select Client Certificate File");
                    String returnFile = fileDialog.open();
                    if (returnFile != null) {
                        QuestionDialog.this.answerText.setText(returnFile);
                    }
                }
            });
        }
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("QuestionDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)rtnGroup, "org.tigris.subversion.subclipse.ui.question_dialog_context");
        this.answerText.setFocus();
        return rtnGroup;
    }

    protected void okPressed() {
        this.answer = this.answerText.getText().trim();
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        if (this.isFilePrompt) {
            this.settings.put("QuestionDialog.certificateFile." + this.realm, this.answer);
        }
        super.okPressed();
    }

    public String getAnswer() {
        return this.answer;
    }

    public boolean isSave() {
        return this.save;
    }
}

