/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.jackson.io.JsonStringEncoder;

public class SerializedString {
    private final String _value;
    private final AtomicReference<byte[]> _quotedUTF8Ref = new AtomicReference();
    private final AtomicReference<byte[]> _unquotedUTF8Ref = new AtomicReference();
    private volatile char[] _quotedChars;

    public SerializedString(String v) {
        this._value = v;
    }

    public final String getValue() {
        return this._value;
    }

    public final int charLength() {
        return this._value.length();
    }

    public char[] asQuotedChars() {
        char[] result = this._quotedChars;
        if (result == null) {
            this._quotedChars = result = JsonStringEncoder.getInstance().quoteAsString(this._value);
        }
        return result;
    }

    public byte[] asUnquotedUTF8() {
        byte[] result = this._unquotedUTF8Ref.get();
        if (result == null) {
            result = JsonStringEncoder.getInstance().encodeAsUTF8(this._value);
            this._unquotedUTF8Ref.set(result);
        }
        return result;
    }

    public byte[] asQuotedUTF8() {
        byte[] result = this._quotedUTF8Ref.get();
        if (result == null) {
            result = JsonStringEncoder.getInstance().quoteAsUTF8(this._value);
            this._quotedUTF8Ref.set(result);
        }
        return result;
    }
}

