/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.model.DataComponentState;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.richfaces.component.UITree;
import org.richfaces.component.state.events.TreeStateCommandsListener;
import org.richfaces.model.ListRowKey;
import org.richfaces.model.TreeRange;
import org.richfaces.model.TreeRowKey;

public class TreeState
implements DataComponentState,
TreeStateCommandsListener,
StateHolder,
Serializable {
    private static final long serialVersionUID = 9083705369340888171L;
    private boolean stopInCollapsed = false;
    private TreeRowKey selectedNode = null;
    private Set<TreeRowKey> expandedNodes = new HashSet<TreeRowKey>();
    private Map<TreeRowKey, NodeState> queuedNodeStates = new HashMap<TreeRowKey, NodeState>();
    private boolean _transient;

    public TreeState() {
    }

    public TreeState(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    public boolean isExpanded(TreeRowKey rowKey) {
        if (rowKey == null) {
            return true;
        }
        NodeState queuedNodeState = this.queuedNodeStates.get(rowKey);
        return this.expandedNodes.contains(rowKey) && !NodeState.COLLAPSED.equals((Object)queuedNodeState) || NodeState.EXPANDED.equals((Object)queuedNodeState);
    }

    public boolean isSelected(TreeRowKey rowKey) {
        return rowKey == null && this.selectedNode == null || this.selectedNode != null && this.selectedNode.equals(rowKey);
    }

    public TreeRowKey getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelected(TreeRowKey rowKey) {
        this.selectedNode = rowKey;
    }

    public Range getRange() {
        if (this.stopInCollapsed) {
            return new TreeRange(){

                public boolean processChildren(TreeRowKey rowKey) {
                    if (rowKey == null) {
                        return true;
                    }
                    return TreeState.this.expandedNodes.contains(rowKey);
                }

                public boolean processNode(TreeRowKey rowKey) {
                    return true;
                }
            };
        }
        return TreeRange.RANGE_UNCONSTRAINED;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.expandedNodes = (Set)_state[0];
        this.queuedNodeStates = (Map)_state[1];
        this._transient = (Boolean)_state[2];
        this.stopInCollapsed = (Boolean)_state[3];
        this.selectedNode = (TreeRowKey)_state[4];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.expandedNodes, this.queuedNodeStates, this._transient, this.stopInCollapsed, this.selectedNode};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isStopInCollapsed() {
        return this.stopInCollapsed;
    }

    public void setStopInCollapsed(boolean stopInCollapsed) {
        this.stopInCollapsed = stopInCollapsed;
    }

    public void expandAll(UITree tree) throws IOException {
        this.queuedNodeStates = new HashMap<TreeRowKey, NodeState>();
        tree.walk(FacesContext.getCurrentInstance(), new ExpansionVisitor(tree), (Range)TreeRange.RANGE_UNCONSTRAINED, null, null);
    }

    public void collapseAll(UITree tree) throws IOException {
        this.queuedNodeStates = new HashMap<TreeRowKey, NodeState>();
        for (TreeRowKey key : this.expandedNodes) {
            this.addQueuedState(key, NodeState.COLLAPSED);
        }
    }

    public void addQueuedState(TreeRowKey rowKey, NodeState state) {
        if (NodeState.EXPANDED.equals((Object)state)) {
            if (!this.expandedNodes.contains(rowKey)) {
                this.queuedNodeStates.put(rowKey, NodeState.EXPANDED);
            }
        } else {
            this.queuedNodeStates.put(rowKey, NodeState.COLLAPSED);
        }
    }

    public void collapseNode(UITree tree, TreeRowKey rowKey) throws IOException {
        this.addQueuedState(rowKey, NodeState.COLLAPSED);
    }

    public void expandNode(UITree tree, TreeRowKey rowKey) throws IOException {
        Object oldRowKey = tree.getRowKey();
        tree.setRowKey(rowKey);
        if (tree.isRowAvailable()) {
            if (!tree.isLeaf()) {
                TreeRowKey key = rowKey;
                while (key != null && key.depth() != 0) {
                    this.addQueuedState(key, NodeState.EXPANDED);
                    key = (TreeRowKey)tree.getParentRowKey(key);
                }
            }
        } else {
            FacesMessage message = new FacesMessage("Row key: " + rowKey + " isn't available!");
            message.setSeverity(FacesMessage.SEVERITY_ERROR);
            FacesContext context = FacesContext.getCurrentInstance();
            context.addMessage(tree.getBaseClientId(context), message);
        }
        tree.setRowKey(oldRowKey);
    }

    private void transferState(TreeRowKey key, NodeState state) {
        if (state != null) {
            if (NodeState.EXPANDED.equals((Object)state)) {
                this.expandedNodes.add(key);
            } else {
                this.expandedNodes.remove(key);
            }
        }
    }

    public void transferQueuedNodes(TreeRowKey rootKey) {
        Iterator<Map.Entry<TreeRowKey, NodeState>> itr = this.queuedNodeStates.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<TreeRowKey, NodeState> entry = itr.next();
            TreeRowKey rowKey = entry.getKey();
            if (rootKey != null && rootKey.depth() != 0 && !rootKey.isSubKey(rowKey)) continue;
            this.transferState(rowKey, entry.getValue());
            itr.remove();
        }
        if (this.queuedNodeStates.isEmpty()) {
            this.queuedNodeStates = new HashMap<TreeRowKey, NodeState>();
        }
    }

    public void makeExpanded(TreeRowKey key) {
        this.queuedNodeStates.remove(key);
        this.expandedNodes.add(key);
    }

    public void makeCollapsed(TreeRowKey key) {
        this.queuedNodeStates.remove(key);
        this.expandedNodes.remove(key);
    }

    public TreeState getSubState(TreeRowKey rowKey) {
        TreeState subTreeState = new TreeState(this.stopInCollapsed);
        if (this.getSelectedNode() != null && rowKey.equals(this.getSelectedNode())) {
            subTreeState.setSelected(rowKey);
        }
        subTreeState._transient = this._transient;
        int subKeyDepth = rowKey.depth() - 1;
        for (TreeRowKey treeRowKey : this.expandedNodes) {
            if (treeRowKey == null || !rowKey.isSubKey(treeRowKey)) continue;
            subTreeState.expandedNodes.add(treeRowKey.getSubKey(subKeyDepth));
        }
        for (Map.Entry entry : this.queuedNodeStates.entrySet()) {
            TreeRowKey nextKey = (TreeRowKey)entry.getKey();
            if (nextKey == null || !rowKey.isSubKey(nextKey)) continue;
            subTreeState.queuedNodeStates.put(nextKey.getSubKey(subKeyDepth), (NodeState)((Object)entry.getValue()));
        }
        return subTreeState;
    }

    public void clearSubState(TreeRowKey rowKey) {
        if (rowKey.equals(this.getSelectedNode())) {
            this.setSelected(null);
        }
        if (rowKey.getPath().equals("null")) {
            this.expandedNodes.clear();
            this.queuedNodeStates = new HashMap<TreeRowKey, NodeState>();
        } else {
            TreeRowKey nextKey;
            Iterator<Object> itr = this.expandedNodes.iterator();
            while (itr.hasNext()) {
                nextKey = itr.next();
                if (nextKey == null || !rowKey.isSubKey(nextKey)) continue;
                itr.remove();
            }
            itr = this.queuedNodeStates.entrySet().iterator();
            while (itr.hasNext()) {
                nextKey = (TreeRowKey)((Map.Entry)itr.next()).getKey();
                if (nextKey == null || !rowKey.isSubKey(nextKey)) continue;
                itr.remove();
            }
        }
    }

    public void mergeSubState(TreeRowKey rowKey, TreeState subState) {
        Iterator<TreeRowKey> iter = subState.expandedNodes.iterator();
        while (iter != null && iter.hasNext()) {
            TreeRowKey key = iter.next().getSubKey(1);
            if (key.depth() > 0) {
                this.expandedNodes.add((TreeRowKey)new ListRowKey((ListRowKey)rowKey, (ListRowKey)key));
                continue;
            }
            if (this.expandedNodes.contains(rowKey)) continue;
            this.expandedNodes.add(rowKey);
        }
        for (Map.Entry<TreeRowKey, NodeState> entry : subState.queuedNodeStates.entrySet()) {
            TreeRowKey key = entry.getKey().getSubKey(1);
            Object newKey = key.depth() > 0 ? new ListRowKey((ListRowKey)rowKey, (ListRowKey)key) : rowKey;
            this.addQueuedState((TreeRowKey)newKey, entry.getValue());
        }
    }

    private class ExpansionVisitor
    implements DataVisitor {
        private UITree tree;

        public ExpansionVisitor(UITree tree) {
            this.tree = tree;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            this.tree.setRowKey(context, rowKey);
            if (!this.tree.isLeaf()) {
                TreeState.this.addQueuedState((TreeRowKey)rowKey, NodeState.EXPANDED);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NodeState {
        EXPANDED,
        COLLAPSED;

    }
}

