/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import java.lang.reflect.Method;
import javax.ws.rs.GET;
import javax.ws.rs.core.CacheControl;
import org.jboss.resteasy.annotations.cache.Cache;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;

@HeaderDecoratorPrecedence
public class CacheControlInterceptor
implements PostProcessInterceptor,
AcceptedByMethod {
    protected CacheControl cacheControl;

    public boolean accept(Class declaring, Method method) {
        if (declaring == null || method == null) {
            return false;
        }
        if (!method.isAnnotationPresent(GET.class)) {
            return false;
        }
        Cache cache = declaring.getAnnotation(Cache.class);
        NoCache nocache = declaring.getAnnotation(NoCache.class);
        Cache methodCached = method.getAnnotation(Cache.class);
        NoCache noMethodCache = method.getAnnotation(NoCache.class);
        if (methodCached != null) {
            this.initCacheControl(methodCached);
        } else if (noMethodCache != null) {
            this.cacheControl = new CacheControl();
            this.cacheControl.setNoCache(true);
        } else if (cache != null) {
            this.initCacheControl(cache);
        } else if (nocache != null) {
            this.cacheControl = new CacheControl();
            this.cacheControl.setNoCache(true);
            for (String field : nocache.fields()) {
                this.cacheControl.getNoCacheFields().add(field);
            }
        }
        return this.cacheControl != null;
    }

    protected void initCacheControl(Cache methodCached) {
        this.cacheControl = new CacheControl();
        if (methodCached.isPrivate()) {
            this.cacheControl.setPrivate(true);
        }
        if (methodCached.maxAge() > -1) {
            this.cacheControl.setMaxAge(methodCached.maxAge());
        }
        if (methodCached.sMaxAge() > -1) {
            this.cacheControl.setSMaxAge(methodCached.sMaxAge());
        }
        this.cacheControl.setMustRevalidate(methodCached.mustRevalidate());
        this.cacheControl.setNoStore(methodCached.noStore());
        this.cacheControl.setNoTransform(methodCached.noTransform());
        this.cacheControl.setProxyRevalidate(methodCached.proxyRevalidate());
    }

    public void postProcess(ServerResponse response) {
        if (response != null && response.getStatus() == 200) {
            response.getMetadata().putSingle((Object)"Cache-Control", (Object)this.cacheControl);
        }
    }
}

