/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.editor.contentassist;

import java.util.HashSet;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.Activator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.core.java.AndMethodFilter;
import org.springframework.ide.eclipse.core.java.IMethodFilter;
import org.springframework.ide.eclipse.core.java.Introspector;
import org.springframework.ide.eclipse.core.java.JdtUtils;

public abstract class MethodContentAssistCalculator
implements IContentAssistCalculator {
    public static final int METHOD_RELEVANCE = 10;
    protected final IMethodFilter filter;

    public MethodContentAssistCalculator(IMethodFilter filter) {
        AndMethodFilter andFilter = new AndMethodFilter();
        andFilter.addMethodFilter((IMethodFilter)new TypeFilterMethodFilterAdapter());
        andFilter.addMethodFilter(filter);
        this.filter = andFilter;
    }

    protected abstract IType calculateType(IContentAssistContext var1);

    @Override
    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        HashSet<String> proposedMethods = new HashSet<String>();
        for (IMethod method : Introspector.findAllMethods((IType)this.calculateType(context), (String)context.getMatchString(), (IMethodFilter)this.filter)) {
            if (proposedMethods.contains(method.getElementName())) continue;
            proposedMethods.add(method.getElementName());
            this.createMethodProposal(recorder, method);
        }
    }

    protected void createMethodProposal(IContentAssistProposalRecorder recorder, IMethod method) {
        try {
            String methodName;
            String[] parameterNames = method.getParameterNames();
            String[] parameterTypes = JdtUtils.getParameterTypesString((IMethod)method);
            String returnType = JdtUtils.getReturnTypeString((IMethod)method, (boolean)true);
            String replaceText = methodName = JdtUtils.getMethodName((IMethod)method);
            StringBuilder buf = new StringBuilder();
            buf.append(replaceText);
            if (parameterTypes.length > 0 && parameterNames.length > 0) {
                buf.append(" (");
                int i = 0;
                while (i < parameterTypes.length) {
                    buf.append(parameterTypes[i]);
                    buf.append(' ');
                    buf.append(parameterNames[i]);
                    if (i < parameterTypes.length - 1) {
                        buf.append(", ");
                    }
                    ++i;
                }
                buf.append(") ");
            } else {
                buf.append("() ");
            }
            if (returnType != null) {
                buf.append(Signature.getSimpleName((String)returnType));
                buf.append(" - ");
            } else {
                buf.append(" void - ");
            }
            buf.append(JdtUtils.getParentName((IMethod)method));
            String displayText = buf.toString();
            Image image = Activator.getDefault().getJavaElementLabelProvider().getImageLabel((Object)method, method.getFlags() | 2);
            recorder.recordProposal(image, 10, displayText, replaceText, method);
        }
        catch (JavaModelException javaModelException) {}
    }

    class TypeFilterMethodFilterAdapter
    implements IMethodFilter {
        TypeFilterMethodFilterAdapter() {
        }

        public boolean matches(IMethod method, String prefix) {
            return !TypeFilter.isFiltered((IType)method.getDeclaringType());
        }
    }
}

