/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.internal.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.ModelUtils;

public class UniqueBeanNameGenerator
implements BeanNameGenerator {
    public static final String GENERATED_BEAN_NAME_PROPERTY = "org.springframework.ide.eclipse.beans.core.GENERATED_BEAN_NAME";
    private IBeansConfig config;

    public UniqueBeanNameGenerator(IBeansConfig config) {
        this.config = config;
    }

    public String generateBeanName(BeanDefinition definition, BeanDefinitionRegistry registry) {
        String name = UniqueBeanNameGenerator.generateBeanName(definition, this.config);
        if (definition instanceof AbstractBeanDefinition) {
            BeanMetadataAttribute attribute = new BeanMetadataAttribute(GENERATED_BEAN_NAME_PROPERTY, (Object)Boolean.TRUE);
            attribute.setSource((Object)this);
            ((AbstractBeanDefinition)definition).addMetadataAttribute(attribute);
        }
        return name;
    }

    public static String generateBeanName(BeanDefinition definition, IBeansConfig config) {
        StringBuilder name = new StringBuilder();
        if (definition.getBeanClassName() != null) {
            name.append(definition.getBeanClassName());
        } else if (definition.getParentName() != null) {
            name.append(definition.getParentName());
            name.append("$child");
        } else if (definition.getFactoryBeanName() != null) {
            name.append(definition.getFactoryBeanName());
            name.append("$created");
        } else {
            name.append("!!!invalid name!!!");
        }
        IModelSourceLocation location = ModelUtils.getSourceLocation((BeanMetadataElement)definition);
        if (location != null) {
            name.append("#");
            name.append(config.getElementParent().getElementName());
            name.append("#");
            name.append(UniqueBeanNameGenerator.generateFilename(config, location));
            name.append("#");
            name.append(location.getStartLine());
        }
        return name.toString();
    }

    private static String generateFilename(IBeansConfig config, IModelSourceLocation location) {
        IResource resource;
        String fileName = config.getElementName();
        if (location.getResource() instanceof IAdaptable && (resource = (IResource)((IAdaptable)location.getResource()).getAdapter(IResource.class)) != null) {
            fileName = resource.getProjectRelativePath().toString();
        }
        return fileName;
    }
}

