/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.configurator.server;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.springsource.ide.eclipse.commons.configurator.ServerHandlerCallback;

public class ServerDescriptor {
    private final String id;
    private String runtimeTypeId;
    private String serverTypeId;
    private String runtimeName;
    private String serverName;
    private String archiveUrl;
    private String installPath;
    private String licenseUrl;
    private String archivePath;
    private String versionRange;
    private String iconPath;
    private String description;
    private String name;
    private String bundleId;
    private ServerHandlerCallback callback;
    private boolean forceCreateRuntime;
    private boolean autoConfigurable;

    public ServerDescriptor(String id) {
        Assert.isNotNull((Object)id);
        this.id = id;
        this.autoConfigurable = true;
    }

    public ServerDescriptor(IConfigurationElement element) {
        String autoConfigurable;
        this.id = element.getAttribute("id");
        this.setArchivePath(element.getAttribute("archivePath"));
        this.setRuntimeTypeId(element.getAttribute("runtimeTypeId"));
        this.setServerTypeId(element.getAttribute("serverTypeId"));
        this.setRuntimeName(element.getAttribute("runtimeName"));
        this.setServerName(element.getAttribute("serverName"));
        this.setName(element.getAttribute("name"));
        this.setDescription(element.getAttribute("description"));
        this.setVersionRange(element.getAttribute("versionRange"));
        this.setInstallPath(element.getAttribute("installPath"));
        this.setBundleId(element.getAttribute("bundleId"));
        if (element.getAttribute("callback") != null) {
            this.setCallback(new ServerHandlerCallbackDelegate(element));
        }
        if ((autoConfigurable = element.getAttribute("autoConfigurable")) != null) {
            this.setAutoConfigurable(Boolean.parseBoolean(autoConfigurable));
        } else {
            this.setAutoConfigurable(true);
        }
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public String getArchiveUrl() {
        return this.archiveUrl;
    }

    public String getBundleId() {
        return this.bundleId;
    }

    public ServerHandlerCallback getCallback() {
        return this.callback;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getForceCreateRuntime() {
        return this.forceCreateRuntime;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getId() {
        return this.id;
    }

    public String getInstallPath() {
        return this.installPath;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getRuntimeTypeId() {
        return this.runtimeTypeId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerTypeId() {
        return this.serverTypeId;
    }

    public String getVersionRange() {
        return this.versionRange;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    protected void setArchiveUrl(String downloadUrl) {
        this.archiveUrl = downloadUrl;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    protected void setCallback(ServerHandlerCallback callback) {
        this.callback = callback;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setForceCreateRuntime(boolean forceCreateRuntime) {
        this.forceCreateRuntime = forceCreateRuntime;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    protected void setInstallPath(String path) {
        this.installPath = path;
    }

    protected void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setRuntimeName(String runtimeName) {
        this.runtimeName = runtimeName;
    }

    protected void setRuntimeTypeId(String runtimeId) {
        this.runtimeTypeId = runtimeId;
    }

    protected void setServerName(String serverName) {
        this.serverName = serverName;
    }

    protected void setServerTypeId(String serverTypeId) {
        this.serverTypeId = serverTypeId;
    }

    protected void setVersionRange(String versionRange) {
        this.versionRange = versionRange;
    }

    public void setAutoConfigurable(boolean autoConfigurable) {
        this.autoConfigurable = autoConfigurable;
    }

    public boolean isAutoConfigurable() {
        return this.autoConfigurable;
    }

    public boolean isValid() {
        return this.getId() != null;
    }

    static class ServerHandlerCallbackDelegate
    extends ServerHandlerCallback {
        private final IConfigurationElement element;

        public ServerHandlerCallbackDelegate(IConfigurationElement element) {
            Assert.isNotNull((Object)element);
            this.element = element;
        }

        @Override
        public void configureServer(IServerWorkingCopy wc) throws CoreException {
            Object object = WorkbenchPlugin.createExtension((IConfigurationElement)this.element, (String)"callback");
            if (object instanceof ServerHandlerCallback) {
                ((ServerHandlerCallback)object).configureServer(wc);
            }
        }
    }
}

