/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.springframework.util.Assert;

public abstract class AbstractCompositeImageDescriptor
extends CompositeImageDescriptor {
    private Image baseImage;
    private int flags;
    private Point size;

    protected AbstractCompositeImageDescriptor(Image baseImage, int flags) {
        Assert.notNull((Object)baseImage);
        this.baseImage = baseImage;
        this.flags = flags;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractCompositeImageDescriptor)) {
            return false;
        }
        AbstractCompositeImageDescriptor other = (AbstractCompositeImageDescriptor)((Object)object);
        return this.baseImage.equals((Object)other.baseImage) && this.flags == other.flags;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.flags;
    }

    public int getFlags() {
        return this.flags;
    }

    protected final Point getSize() {
        if (this.size == null) {
            ImageData data = this.baseImage.getImageData();
            this.size = new Point(data.width, data.height);
        }
        return this.size;
    }

    protected final void drawCompositeImage(int width, int height) {
        ImageData background = this.baseImage.getImageData();
        if (background == null) {
            background = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(background, 0, 0);
        this.drawOverlays();
    }

    protected abstract void drawOverlays();
}

