/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReturnCountExtendedCheck
extends Check {
    public static final String WARNING_MSG_KEY_METHOD = "return.count.extended.method";
    public static final String WARNING_MSG_KEY_CTOR = "return.count.extended.ctor";
    private static final int DEFAULT_MAX_RETURN_COUNT = 1;
    private static final int DEFAULT_IGNORE_METHOD_LINES_COUNT = 20;
    private static final int DEFAULT_MIN_IGNORE_RETURN_DEPTH = 4;
    private static final int DEFAULT_TOP_LINES_TO_IGNORE_COUNT = 5;
    private Set<String> ignoreMethodsNames = new HashSet<String>();
    private int maxReturnCount = 1;
    private int ignoreMethodLinesCount = 20;
    private int minIgnoreReturnDepth = 4;
    private boolean ignoreEmptyReturns = true;
    private int topLinesToIgnoreCount = 5;

    public void setIgnoreMethodsNames(String[] ignoreMethodNames) {
        this.ignoreMethodsNames.clear();
        if (ignoreMethodNames != null) {
            for (String name : ignoreMethodNames) {
                this.ignoreMethodsNames.add(name);
            }
        }
    }

    public void setMaxReturnCount(int maxReturnCount) {
        this.maxReturnCount = maxReturnCount;
    }

    public void setIgnoreMethodLinesCount(int ignoreMethodLinesCount) {
        this.ignoreMethodLinesCount = ignoreMethodLinesCount;
    }

    public void setMinIgnoreReturnDepth(int minIgnoreReturnDepth) {
        this.minIgnoreReturnDepth = minIgnoreReturnDepth;
    }

    public void setIgnoreEmptyReturns(boolean ignoreEmptyReturns) {
        this.ignoreEmptyReturns = ignoreEmptyReturns;
    }

    public void setTopLinesToIgnoreCount(int topLinesToIgnoreCount) {
        this.topLinesToIgnoreCount = topLinesToIgnoreCount;
    }

    public ReturnCountExtendedCheck() {
        this.ignoreMethodsNames.add("equals");
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public void visitToken(DetailAST methodDefNode) {
        DetailAST openingBrace = methodDefNode.findFirstToken(7);
        String methodName = ReturnCountExtendedCheck.getMethodName(methodDefNode);
        if (openingBrace != null && !ReturnCountExtendedCheck.matches(methodName, this.ignoreMethodsNames)) {
            int mCurReturnCount;
            DetailAST closingBrace = openingBrace.getLastChild();
            int curMethodLinesCount = ReturnCountExtendedCheck.getLinesCount(openingBrace, closingBrace);
            if (curMethodLinesCount != 0) {
                --curMethodLinesCount;
            }
            if (curMethodLinesCount >= this.ignoreMethodLinesCount && (mCurReturnCount = this.getReturnCount(methodDefNode, openingBrace)) > this.maxReturnCount) {
                String mKey = methodDefNode.getType() == 9 ? WARNING_MSG_KEY_METHOD : WARNING_MSG_KEY_CTOR;
                DetailAST methodNameToken = methodDefNode.findFirstToken(58);
                this.log(methodNameToken, mKey, new Object[]{methodName, mCurReturnCount, this.maxReturnCount});
            }
        }
    }

    private int getReturnCount(DetailAST methodDefNode, DetailAST methodOpeningBrace) {
        int result = 0;
        DetailAST curNode = methodOpeningBrace;
        while (curNode != null && (curNode.getType() != 73 || curNode.getParent() != methodOpeningBrace)) {
            if (curNode.getType() == 88 && ReturnCountExtendedCheck.getDepth(methodDefNode, curNode) < this.minIgnoreReturnDepth && this.shouldEmptyReturnStatementBeCounted(curNode) && ReturnCountExtendedCheck.getLinesCount(methodOpeningBrace, curNode) > this.topLinesToIgnoreCount) {
                ++result;
            }
            DetailAST nextNode = curNode.getFirstChild();
            int type = curNode.getType();
            if (type == 9 || type == 14) {
                nextNode = curNode.getNextSibling();
            }
            while (curNode != null && nextNode == null) {
                nextNode = curNode.getNextSibling();
                if (nextNode != null) continue;
                curNode = curNode.getParent();
            }
            curNode = nextNode;
        }
        return result;
    }

    private boolean shouldEmptyReturnStatementBeCounted(DetailAST returnNode) {
        DetailAST returnChildNode = returnNode.getFirstChild();
        return !this.ignoreEmptyReturns || returnChildNode.getType() != 45;
    }

    private static int getDepth(DetailAST methodDefNode, DetailAST returnStmtNode) {
        int result = 0;
        DetailAST curNode = returnStmtNode;
        while (!curNode.equals((AST)methodDefNode)) {
            int type = (curNode = curNode.getParent()).getType();
            if (type != 83 && type != 89 && type != 91 && type != 85 && type != 84 && type != 95) continue;
            ++result;
        }
        return result;
    }

    private static String getMethodName(DetailAST methodDefNode) {
        String result = null;
        for (DetailAST curNode : ReturnCountExtendedCheck.getChildren(methodDefNode)) {
            if (curNode.getType() != 58) continue;
            result = curNode.getText();
            break;
        }
        return result;
    }

    private static int getLinesCount(DetailAST beginAst, DetailAST endAST) {
        return endAST.getLineNo() - beginAst.getLineNo();
    }

    private static List<DetailAST> getChildren(DetailAST node) {
        LinkedList<DetailAST> result = new LinkedList<DetailAST>();
        for (DetailAST curNode = node.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
            result.add(curNode);
        }
        return result;
    }

    private static boolean matches(String string, Collection<String> patterns) {
        boolean result = false;
        if (!patterns.isEmpty()) {
            for (String pattern : patterns) {
                if (!string.matches(pattern)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

