/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.SourceRefElement;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.springframework.ide.eclipse.quickfix.QuickfixImages;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AnnotationCompletionProposal;

public class ClassCompletionProposal
extends AnnotationCompletionProposal {
    private final String className;
    private Annotation annotation;
    private ASTNode oldLiteral;
    private final IPackageFragment packageFragment;
    private final IAnnotation iAnnotation;
    private final JavaContentAssistInvocationContext javaContext;

    public ClassCompletionProposal(String className, IAnnotation a, IPackageFragment packageFragment, JavaContentAssistInvocationContext javaContext) {
        super(String.valueOf(className) + ".class", javaContext.getCompilationUnit(), QuickfixImages.getImage(QuickfixImages.CLASS));
        this.className = className;
        this.iAnnotation = a;
        this.packageFragment = packageFragment;
        this.javaContext = javaContext;
    }

    private void setupASTNodes() {
        ICompilationUnit cu = this.javaContext.getCompilationUnit();
        SourceViewer sourceViewer = (SourceViewer)this.javaContext.getViewer();
        int invocationOffset = this.javaContext.getInvocationOffset();
        AssistContext assistContext = new AssistContext(cu, (ISourceViewer)sourceViewer, invocationOffset, 0);
        ASTNode node = ((SourceRefElement)this.iAnnotation).findNode(assistContext.getASTRoot());
        this.annotation = (Annotation)node;
        if (node instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)node;
            List pairs = normalAnnotation.values();
            for (MemberValuePair pair : pairs) {
                Expression value = pair.getValue();
                if (value instanceof TypeLiteral) {
                    if (!this.isWithinRange(value, invocationOffset)) continue;
                    this.oldLiteral = value;
                    continue;
                }
                if (!(value instanceof ArrayInitializer)) continue;
                ArrayInitializer arrayInit = (ArrayInitializer)value;
                List expressions = arrayInit.expressions();
                for (Expression expression : expressions) {
                    if (expression instanceof TypeLiteral) {
                        if (!this.isWithinRange(expression, invocationOffset)) continue;
                        this.oldLiteral = expression;
                        continue;
                    }
                    if (!(expression instanceof SimpleName) || !this.isWithinRange(expression, invocationOffset)) continue;
                    this.oldLiteral = expression;
                }
            }
        }
    }

    private boolean isWithinRange(Expression value, int invocationOffset) {
        int startPosition = value.getStartPosition();
        int length = value.getLength();
        return startPosition < invocationOffset && startPosition + length >= invocationOffset;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        this.setupASTNodes();
        AST ast = this.annotation.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.oldLiteral == null) {
            return rewrite;
        }
        SimpleName typeName = ast.newSimpleName(this.className);
        SimpleType type = ast.newSimpleType((Name)typeName);
        TypeLiteral typeLiteral = ast.newTypeLiteral();
        typeLiteral.setType((Type)type);
        final ITrackedNodePosition newValuePosition = rewrite.track((ASTNode)typeLiteral);
        rewrite.replace(this.oldLiteral, (ASTNode)typeLiteral, null);
        if (this.packageFragment != null) {
            ImportRewrite importRewrite = this.createImportRewrite(ASTResolving.findParentCompilationUnit((ASTNode)this.oldLiteral));
            importRewrite.addImport(String.valueOf(this.packageFragment.getElementName()) + "." + this.className);
        }
        this.setTrackPosition(new ITrackedNodePosition(){

            public int getStartPosition() {
                return newValuePosition.getStartPosition() + newValuePosition.getLength();
            }

            public int getLength() {
                return 0;
            }
        });
        return rewrite;
    }
}

