/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.model.ITestCaseElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.ITestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.ITestSuiteElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestCaseElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestSuiteElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestResultsView;
import java.text.NumberFormat;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class TestSessionLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final TestResultsView fTestRunnerPart;
    private final int fLayoutMode;
    private final NumberFormat timeFormat;
    private boolean fShowTime;

    public TestSessionLabelProvider(TestResultsView testRunnerPart, int layoutMode) {
        this.fTestRunnerPart = testRunnerPart;
        this.fLayoutMode = layoutMode;
        this.fShowTime = true;
        this.timeFormat = NumberFormat.getNumberInstance();
        this.timeFormat.setGroupingUsed(true);
        this.timeFormat.setMinimumFractionDigits(3);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumIntegerDigits(1);
    }

    public StyledString getStyledText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return new StyledString(element.toString());
        }
        StyledString text = new StyledString(label);
        ITestElement testElement = (ITestElement)element;
        if (this.fLayoutMode != 1 && element instanceof ITestCaseElement) {
            String className = BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestClassName());
            String decorated = NLS.bind((String)"{0} - {1}", (Object[])new Object[]{label, className});
            text = StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.QUALIFIER_STYLER, (StyledString)text);
        }
        return this.addElapsedTime(text, testElement.getElapsedTimeInSeconds());
    }

    private StyledString addElapsedTime(StyledString styledString, double time) {
        String string = styledString.getString();
        String decorated = this.addElapsedTime(string, time);
        return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)StyledString.COUNTER_STYLER, (StyledString)styledString);
    }

    private String addElapsedTime(String string, double time) {
        if (!this.fShowTime || Double.isNaN(time)) {
            return string;
        }
        String formattedTime = this.timeFormat.format(time);
        return NLS.bind((String)"{0} ({1} s)", (Object[])new String[]{string, formattedTime});
    }

    private String getSimpleLabel(Object element) {
        if (element instanceof ITestCaseElement) {
            return BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestMethodName());
        }
        if (element instanceof ITestSuiteElement) {
            return BasicElementLabels.getJavaElementName((String)((ITestSuiteElement)element).getSuiteTypeName());
        }
        return null;
    }

    public String getText(Object element) {
        String label = this.getSimpleLabel(element);
        if (label == null) {
            return element.toString();
        }
        ITestElement testElement = (ITestElement)element;
        if (this.fLayoutMode != 1 && element instanceof ITestCaseElement) {
            String className = BasicElementLabels.getJavaElementName((String)((ITestCaseElement)element).getTestClassName());
            label = NLS.bind((String)"{0} - {1}", (Object[])new Object[]{label, className});
        }
        return this.addElapsedTime(label, testElement.getElapsedTimeInSeconds());
    }

    public Image getImage(Object element) {
        if (element instanceof TestCaseElement) {
            TestCaseElement testCaseElement = (TestCaseElement)element;
            TestElement.Status status = testCaseElement.getStatus();
            if (status.isError()) {
                return this.fTestRunnerPart.fTestErrorIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fTestOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        if (element instanceof TestSuiteElement) {
            TestElement.Status status = ((TestSuiteElement)element).getStatus();
            if (status.isError()) {
                return this.fTestRunnerPart.fSuiteErrorIcon;
            }
            if (status.isOK()) {
                return this.fTestRunnerPart.fSuiteOkIcon;
            }
            throw new IllegalStateException(element.toString());
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    public void setShowTime(boolean showTime) {
        this.fShowTime = showTime;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

