/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.Bean;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansImport;
import org.springframework.ide.eclipse.beans.core.model.IBeansModel;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.IBeansProject;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.model.BeansModelImageDescriptor;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.ILazyInitializedModelElement;
import org.springframework.ide.eclipse.core.model.IModelChangeListener;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.ModelChangeEvent;
import org.springframework.ide.eclipse.ui.SpringLabelDecorator;

public class BeansModelLabelDecorator
extends SpringLabelDecorator
implements ILightweightLabelDecorator,
ILabelDecorator {
    public static final String DECORATOR_ID = "org.springframework.ide.eclipse.beans.ui.model.beansModelLabelDecorator";
    private IModelChangeListener listener = new IModelChangeListener(){

        public void elementChanged(ModelChangeEvent event) {
            if ((event.getElement() instanceof IBeansProject || event.getElement() instanceof IBeansConfig) && event.getType() != ModelChangeEvent.Type.REMOVED) {
                BeansModelLabelDecorator.this.internalUpdate();
            }
        }
    };

    public static void update() {
        IBaseLabelProvider provider;
        if (PlatformUI.isWorkbenchRunning() && (provider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider(DECORATOR_ID)) instanceof BeansModelLabelDecorator) {
            ((BeansModelLabelDecorator)provider).internalUpdate();
        }
    }

    private void internalUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IBaseLabelProvider provider = PlatformUI.getWorkbench().getDecoratorManager().getBaseLabelProvider("org.springframework.ide.eclipse.ui.model.modelLabelDecorator");
                if (provider != null) {
                    BeansModelLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent(provider));
                }
                BeansModelLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)BeansModelLabelDecorator.this));
            }
        });
    }

    public BeansModelLabelDecorator() {
        BeansCorePlugin.getModel().addChangeListener(this.listener);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFolder) {
            this.decorateFolder((IFolder)element, decoration);
        } else if (element instanceof IFile) {
            this.decorateFile((IFile)element, decoration);
        } else if (element instanceof IJavaElement) {
            this.decorateJavaElement((IJavaElement)element, decoration);
        } else if (element instanceof IBeansModelElement) {
            if (element instanceof Bean) {
                this.decorateBean((Bean)element, decoration);
            }
            this.decorateBeansModelElement((IBeansModelElement)element, decoration);
        }
    }

    private void decorateBean(Bean bean, IDecoration decoration) {
        BeanDefinition bd = bean.getBeanDefinition();
        if (bean.isChildBean()) {
            decoration.addOverlay(BeansUIImages.DESC_OVR_CHILD, 1);
        }
        if (bean.isFactory()) {
            decoration.addOverlay(BeansUIImages.DESC_OVR_FACTORY, 0);
        }
        if (bean.isAbstract()) {
            decoration.addOverlay(BeansUIImages.DESC_OVR_ABSTRACT, 3);
        }
        if (!bean.isSingleton()) {
            decoration.addOverlay(BeansUIImages.DESC_OVR_PROTOTYPE, 3);
        }
        if (bd instanceof AnnotatedBeanDefinition) {
            decoration.addOverlay(BeansUIImages.DESC_OVR_ANNOTATION, 2);
        }
    }

    private void decorateBeansModelElement(IBeansModelElement element, IDecoration decoration) {
        this.addErrorOverlay(decoration, this.getSeverity(element));
    }

    protected void decorateFile(IFile file, IDecoration decoration) {
        IBeansModel model = BeansCorePlugin.getModel();
        IBeansProject project = model.getProject(file.getProject());
        if (project instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)project).isInitialized()) {
            return;
        }
        IBeansConfig config = model.getConfig(file, true);
        if (config != null) {
            this.addErrorOverlay(decoration, this.getSeverity(config));
            decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
        }
    }

    protected void decorateFolder(IFolder folder, IDecoration decoration) {
        IBeansModel model = BeansCorePlugin.getModel();
        IBeansProject project = model.getProject(folder.getProject());
        if (project instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)project).isInitialized()) {
            return;
        }
        if (project != null) {
            String path = String.valueOf(folder.getProjectRelativePath().toString()) + '/';
            for (IBeansConfig config : project.getConfigs()) {
                if (!config.getElementName().startsWith(path)) continue;
                decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                break;
            }
        }
    }

    protected void decorateJavaElement(IJavaElement element, IDecoration decoration) {
        block9: {
            IBeansModel model;
            IBeansProject project;
            int type = element.getElementType();
            if ((type == 3 || type == 6 || type == 5) && (project = (model = BeansCorePlugin.getModel()).getProject(element.getJavaProject().getProject())) instanceof ILazyInitializedModelElement && ((ILazyInitializedModelElement)project).isInitialized()) {
                try {
                    if (type == 3) {
                        IResource resource = ((IPackageFragmentRoot)element).getResource();
                        if (!(resource instanceof IFile)) break block9;
                        for (IBeansConfig config : project.getConfigs()) {
                            if (!config.getElementResource().equals((Object)resource)) continue;
                            decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                            break block9;
                        }
                        break block9;
                    }
                    if (type == 6) {
                        IType javaType = ((IClassFile)element).getType();
                        if (BeansModelUtils.isBeanClass((IType)javaType)) {
                            decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                        }
                        break block9;
                    }
                    if (type != 5) break block9;
                    IType[] iTypeArray = ((ICompilationUnit)element).getTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType javaType = iTypeArray[n2];
                        if (BeansModelUtils.isBeanClass((IType)javaType)) {
                            decoration.addOverlay(BeansUIImages.DESC_OVR_SPRING);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    public void dispose() {
        BeansCorePlugin.getModel().removeChangeListener(this.listener);
    }

    protected int getSeverity(Object element) {
        int severity = 0;
        if (element instanceof ILazyInitializedModelElement && !((ILazyInitializedModelElement)element).isInitialized()) {
            return 0;
        }
        if (element instanceof IBeansImport) {
            severity = this.getSeverityForImport((IBeansImport)element);
        } else if (element instanceof ISourceModelElement) {
            ISourceModelElement source = (ISourceModelElement)element;
            severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)source.getElementResource(), (int)source.getElementStartLine(), (int)source.getElementEndLine());
        } else if (element instanceof IResourceModelElement) {
            if (element instanceof IBeansProject) {
                int s = 0;
                for (IBeansConfig config : ((IBeansProject)element).getConfigs()) {
                    s = this.getSeverityForConfig(config);
                    if (s > severity) {
                        severity = s;
                    }
                    if (severity != 2) {
                        continue;
                    }
                    break;
                }
            } else if (element instanceof IBeansConfigSet) {
                int s = 0;
                for (IBeansConfig config : ((IBeansConfigSet)element).getConfigs()) {
                    severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)config.getElementResource(), (int)-1, (int)-1);
                    if (s > severity) {
                        severity = s;
                    }
                    if (severity != 2) {
                        continue;
                    }
                    break;
                }
            } else {
                severity = element instanceof IBeansConfig ? this.getSeverityForConfig((IBeansConfig)element) : MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)((IResourceModelElement)element).getElementResource(), (int)-1, (int)-1);
            }
        } else if (element instanceof IResource) {
            severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)((IResource)element), (int)-1, (int)-1);
        } else if (element instanceof ZipEntryStorage) {
            IFile resource = ((ZipEntryStorage)element).getFile();
            severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)resource, (int)-1, (int)-1);
        }
        return severity;
    }

    private int getSeverityForConfig(IBeansConfig beansConfig) {
        int severity = MarkerUtils.getHighestSeverityFromMarkersInRange((IResource)beansConfig.getElementResource(), (int)-1, (int)-1);
        for (IBeansImport beanImport : beansConfig.getImports()) {
            int importedSeverity = this.getSeverityForImport(beanImport);
            if (importedSeverity == 1) {
                severity = importedSeverity;
                continue;
            }
            if (importedSeverity != 2) continue;
            severity = importedSeverity;
            break;
        }
        return severity;
    }

    private int getSeverityForImport(IBeansImport beanImport) {
        int severity = 0;
        for (IBeansConfig importedConfig : beanImport.getImportedBeansConfigs()) {
            int importedSeverity = this.getSeverityForConfig(importedConfig);
            if (importedSeverity == 1) {
                severity = importedSeverity;
                continue;
            }
            if (importedSeverity != 2) continue;
            severity = importedSeverity;
            break;
        }
        return severity;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public Image decorateImage(Image image, Object element) {
        int severity = this.getSeverity(element);
        int flags = 0;
        if (severity == 1) {
            flags |= 8;
        } else if (severity == 2) {
            flags |= 4;
        }
        if (element instanceof IBeansModelElement && image != null) {
            BeansModelImageDescriptor descriptor = new BeansModelImageDescriptor(image, (IBeansModelElement)element, flags);
            image = BeansUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)descriptor);
        }
        return image;
    }

    public String decorateText(String text, Object element) {
        return text;
    }
}

