/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.ui.BeansUIImages;

class BeansModelImageDescriptor
extends CompositeImageDescriptor {
    public static final int FLAG_ERROR = 4;
    public static final int FLAG_WARNING = 8;
    private Image baseImage;
    private Point size;
    private int flags;

    public BeansModelImageDescriptor(Image baseImage, IBeansModelElement state, int flags) {
        this.baseImage = baseImage;
        this.size = this.getSize();
        this.flags = flags;
    }

    protected Point getSize() {
        if (this.size == null) {
            ImageData data = this.baseImage.getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.size;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData background = this.baseImage.getImageData();
        if (background == null) {
            background = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(background, 0, 0);
        this.drawOverlays();
    }

    protected void drawOverlays() {
        int x = 0;
        int y = this.baseImage.getBounds().height / 2;
        ImageData data = null;
        if ((this.flags & 4) != 0) {
            data = BeansUIImages.DESC_OVR_ERROR.getImageData();
            this.drawImage(data, x, y);
        }
        if ((this.flags & 8) != 0) {
            data = BeansUIImages.DESC_OVR_WARNING.getImageData();
            this.drawImage(data, x, y);
        }
    }

    protected void setSize(Point size) {
        this.size = size;
    }

    public int hashCode() {
        return this.baseImage.hashCode() | this.flags | this.size.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !BeansModelImageDescriptor.class.equals(object.getClass())) {
            return false;
        }
        BeansModelImageDescriptor other = (BeansModelImageDescriptor)((Object)object);
        return this.baseImage.equals((Object)other.baseImage) && this.flags == other.flags | this.size.equals((Object)other.size);
    }

    public String toString() {
        return this.baseImage.toString();
    }
}

