/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;

public class ExistingBootProjectSelectionValidator
extends Validator {
    private LiveExpression<IProject> selection;

    public ExistingBootProjectSelectionValidator(LiveExpression<IProject> selection) {
        Assert.isNotNull(selection);
        this.selection = selection;
        this.dependsOn(selection);
    }

    protected ValidationResult compute() {
        IProject p = (IProject)this.selection.getValue();
        if (p == null) {
            return ValidationResult.error((String)"No project selected");
        }
        if (!p.exists()) {
            return ValidationResult.error((String)("Project '" + p.getName() + "' does not exist in the workspace"));
        }
        if (!p.isAccessible()) {
            return ValidationResult.error((String)("Project '" + p.getName() + "' is closed"));
        }
        if (!BootPropertyTester.isBootProject((IProject)p)) {
            return ValidationResult.error((String)("Project '" + p.getName() + "' does not look like a Boot project"));
        }
        return ValidationResult.OK;
    }
}

