/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.swt.graphics.Color;

public class ActivityContainerHighlightEditPolicy
extends GraphicalEditPolicy {
    private Color revertColor;
    private static Color highLightColor = new Color(null, 200, 200, 240);

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.setContainerBackground(this.revertColor);
            this.revertColor = null;
        }
    }

    private Color getContainerBackground() {
        return this.getContainerFigure().getBackgroundColor();
    }

    private IFigure getContainerFigure() {
        return ((GraphicalEditPart)this.getHost()).getFigure();
    }

    public EditPart getTargetEditPart(Request request) {
        return request.getType().equals("selection hover") ? this.getHost() : null;
    }

    private void setContainerBackground(Color c) {
        this.getContainerFigure().setBackgroundColor(c);
    }

    protected void showHighlight() {
        if (this.revertColor == null) {
            this.revertColor = this.getContainerBackground();
            this.setContainerBackground(highLightColor);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("create child") || request.getType().equals("add children")) {
            this.showHighlight();
        }
    }
}

