/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tigris.subversion.subclipse.ui.Policy;

public class DeletePropertyDialog
extends Dialog {
    private String message;
    private boolean directory;
    private Button recurseButton;
    private boolean recurse;

    public DeletePropertyDialog(Shell parentShell, String message, boolean directory) {
        super(parentShell);
        this.message = message;
        this.directory = directory;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("SVNPropertyDeleteAction.title"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label questionLabel = new Label(composite, 0);
        questionLabel.setImage(this.getShell().getDisplay().getSystemImage(4));
        Label confirmLabel = new Label(composite, 64);
        GridData data = new GridData();
        data.widthHint = 400;
        confirmLabel.setText(this.message);
        if (this.directory) {
            new Label(composite, 0);
            this.recurseButton = new Button(composite, 32);
            this.recurseButton.setText(Policy.bind("SVNPropertyDeleteAction.recurse"));
            data = new GridData();
            data.horizontalSpan = 2;
            this.recurseButton.setLayoutData((Object)data);
        }
        return composite;
    }

    protected void okPressed() {
        if (this.directory) {
            this.recurse = this.recurseButton.getSelection();
        }
        super.okPressed();
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    protected Image getImage() {
        return this.getShell().getDisplay().getSystemImage(4);
    }
}

