/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springsource.ide.eclipse.commons.ui.SpringUIUtils;
import org.w3c.dom.Node;

public class WebflowNamespaceUtils {
    public static Node locateFlowRootNode(Node node) {
        if (!"flow".equals(node.getLocalName()) && node.getParentNode() != null) {
            return WebflowNamespaceUtils.locateFlowRootNode(node.getParentNode());
        }
        return node;
    }

    public static IWebflowConfig getActiveWebflowConfig() {
        IWebflowProject project;
        IEditorInput editorInput = SpringUIUtils.getActiveEditor().getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput && (project = Activator.getModel().getProject(((IFileEditorInput)editorInput).getFile().getProject())) != null) {
            return project.getConfig(((IFileEditorInput)editorInput).getFile());
        }
        return null;
    }

    public static String[] getWebflowConfigNames() {
        IWebflowConfig webflowConfig = WebflowNamespaceUtils.getActiveWebflowConfig();
        if (webflowConfig != null) {
            IWebflowProject project = webflowConfig.getProject();
            return WebflowModelUtils.getWebflowConfigNames((IWebflowProject)project).toArray(new String[0]);
        }
        return new String[0];
    }
}

