/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class PropertyNavigator {
    private static final char EOF = '\u0000';
    private SpringPropertiesReconcileEngine.IProblemCollector problemCollector;
    private IDocument doc;
    private TypeUtil typeUtil;
    private IRegion region;
    private String regionText;

    public PropertyNavigator(IDocument doc, SpringPropertiesReconcileEngine.IProblemCollector problemCollector, TypeUtil typeUtil, IRegion region) throws BadLocationException {
        this.doc = doc;
        this.problemCollector = problemCollector == null ? SpringPropertiesReconcileEngine.IProblemCollector.NULL : problemCollector;
        this.typeUtil = typeUtil;
        this.region = region;
        this.regionText = doc.get(region.getOffset(), region.getLength());
    }

    public Type navigate(int offset, Type type) {
        if (type != null) {
            if (offset < this.getEnd(this.region)) {
                char navOp = this.getChar(offset);
                if (navOp == '.') {
                    if (this.typeUtil.isDotable(type)) {
                        return this.dotNavigate(offset, type);
                    }
                    this.problemCollector.accept(SpringPropertyProblem.error("Can't use '.' navigation for property '" + this.textBetween(this.region.getOffset(), offset) + "' of type " + type, offset, this.getEnd(this.region) - offset));
                } else if (navOp == '[') {
                    if (TypeUtil.isBracketable(type)) {
                        return this.bracketNavigate(offset, type);
                    }
                    this.problemCollector.accept(SpringPropertyProblem.error("Can't use '[..]' navigation for property '" + this.textBetween(this.region.getOffset(), offset) + "' of type " + type, offset, this.getEnd(this.region) - offset));
                } else {
                    this.problemCollector.accept(SpringPropertyProblem.error("Expecting either a '.' or '['", offset, this.getEnd(this.region) - offset));
                }
            } else {
                return type;
            }
        }
        return null;
    }

    private String textBetween(int start, int end) {
        try {
            if (end > start) {
                return this.doc.get(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    private int indexOf(char c, int from) {
        int offset = this.region.getOffset();
        int found = this.regionText.indexOf(c, from - offset);
        if (found >= 0) {
            return found + offset;
        }
        return -1;
    }

    private Type bracketNavigate(int offset, Type type) {
        int lbrack = offset;
        int rbrack = this.indexOf(']', lbrack);
        if (rbrack >= 0) {
            String indexStr = this.textBetween(lbrack + 1, rbrack);
            if (!indexStr.contains("${")) {
                try {
                    Integer.parseInt(indexStr);
                }
                catch (Exception exception) {
                    this.problemCollector.accept(SpringPropertyProblem.error("Expecting 'Integer' for '[...]' notation '" + this.textBetween(this.region.getOffset(), lbrack) + "'", lbrack + 1, rbrack - lbrack - 1));
                }
            }
            Type domainType = TypeUtil.getDomainType(type);
            return this.navigate(rbrack + 1, domainType);
        }
        this.problemCollector.accept(SpringPropertyProblem.error("No matching ']'", offset, 1));
        return null;
    }

    private Type dotNavigate(int offset, Type type) {
        if (TypeUtil.isMap(type)) {
            TypeUtil.ValueParser keyParser;
            int keyStart = offset + 1;
            Type domainType = TypeUtil.getDomainType(type);
            int keyEnd = -1;
            keyEnd = this.typeUtil.isDotable(domainType) ? this.nextNavOp(".[", offset + 1) : this.nextNavOp("[", offset + 1);
            String key = this.textBetween(keyStart, keyEnd);
            Type keyType = TypeUtil.getKeyType(type);
            if (keyType != null && (keyParser = this.typeUtil.getValueParser(keyType)) != null) {
                try {
                    keyParser.parse(key);
                }
                catch (Exception exception) {
                    this.problemCollector.accept(SpringPropertyProblem.error("Expecting " + this.typeUtil.niceTypeName(keyType), keyStart, keyEnd - keyStart));
                }
            }
            return this.navigate(keyEnd, domainType);
        }
        int keyStart = offset + 1;
        int keyEnd = this.nextNavOp(".[", offset + 1);
        if (keyEnd < 0) {
            keyEnd = this.getEnd(this.region);
        }
        String key = StringUtil.camelCaseToHyphens((String)this.textBetween(keyStart, keyEnd));
        List<TypedProperty> properties = this.typeUtil.getProperties(type, TypeUtil.EnumCaseMode.ALIASED);
        if (properties != null) {
            TypedProperty prop = null;
            for (TypedProperty p : properties) {
                if (!p.getName().equals(key)) continue;
                prop = p;
                break;
            }
            if (prop == null) {
                this.problemCollector.accept(SpringPropertyProblem.error("Type '" + this.typeUtil.niceTypeName(type) + "' has no property '" + key + "'", keyStart, keyEnd - keyStart));
            } else {
                return this.navigate(keyEnd, prop.getType());
            }
        }
        return null;
    }

    private int nextNavOp(String navops, int pos) {
        int end = this.getEnd(this.region);
        while (pos < end && navops.indexOf(this.getChar(pos)) < 0) {
            ++pos;
        }
        return Math.min(pos, end);
    }

    private char getChar(int offset) {
        try {
            return this.doc.getChar(offset);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    private int getEnd(IRegion region) {
        return region.getOffset() + region.getLength();
    }
}

