/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.metadata.MetadataPlugin;

public class MetadataUIImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.metadata.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.metadata.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_OBJS_ASPECT = "org.springframework.ide.eclipse.metadata.aspect_obj.gif";
    public static final String IMG_OBJS_AROUND_ADVICE = "org.springframework.ide.eclipse.metadata.around_advice_obj.gif";
    public static final String IMG_OBJS_BEFORE_ADVICE = "org.springframework.ide.eclipse.metadata.before_advice_obj.gif";
    public static final String IMG_OBJS_AFTER_ADVICE = "org.springframework.ide.eclipse.metadata.after_advice_obj.gif";
    public static final String IMG_OBJS_DECLARE_PARENTS = "org.springframework.ide.eclipse.metadata.dec_parents_obj.gif";
    public static final String IMG_OBJS_DECLARE_ERROR = "org.springframework.ide.eclipse.metadata.dec_error_obj.gif";
    public static final String IMG_OBJS_DECLARE_WARNING = "org.springframework.ide.eclipse.metadata.dec_warning_obj.gif";
    public static final String IMG_OBJS_DECLARE_ANNOTATION = "org.springframework.ide.eclipse.metadata.dec_annotation_obj.gif";
    public static final String IMG_OBJS_POINTCUT = "org.springframework.ide.eclipse.metadata.pointcut_pub_obj.gif";
    public static final String IMG_OBJS_TX = "org.springframework.ide.eclipse.metadata.tx_obj.gif";
    public static final String IMG_OBJS_ANNOTATION = "org.springframework.ide.eclipse.metadata.annotation_obj.gif";
    public static final String IMG_OBJS_REQUEST_MAPPING = "org.springframework.ide.eclipse.metadata.request_mapping_obj.gif";
    public static final String IMG_OBJS_ANNOTATION_BEAN = "org.springframework.ide.eclipse.metadata.configuration_bean_obj.gif";
    public static final String IMG_OBJS_BREAKPOINT = "org.springframework.ide.eclipse.metadata.brkp_obj.gif";
    public static final String IMG_OBJS_JAVA_FILE = "org.springframework.ide.eclipse.metadata.jcu_obj.gif";
    public static final String IMG_OBJS_BROWSER = "org.springframework.ide.eclipse.metadata.internal_browser.gif";
    public static final String IMG_OBJS_ORIENTATION_HORIZONTAL = "org.springframework.ide.eclipse.metadata.th_horizontal.gif";
    public static final String IMG_OBJS_ORIENTATION_VERTICAL = "org.springframework.ide.eclipse.metadata.th_vertical.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_ASPECT;
    public static final ImageDescriptor DESC_OBJS_AROUND_ADVICE;
    public static final ImageDescriptor DESC_OBJS_BEFORE_ADVICE;
    public static final ImageDescriptor DESC_OBJS_AFTER_ADVICE;
    public static final ImageDescriptor DESC_OBJS_DECLARE_PARENTS;
    public static final ImageDescriptor DESC_OBJS_DECLARE_WARNING;
    public static final ImageDescriptor DESC_OBJS_DECLARE_ERROR;
    public static final ImageDescriptor DESC_OBJS_DECLARE_ANNOTATION;
    public static final ImageDescriptor DESC_OBJS_POINTCUT;
    public static final ImageDescriptor DESC_OBJS_TX;
    public static final ImageDescriptor DESC_OBJS_ANNOTATION;
    public static final ImageDescriptor DESC_OBJS_REQUEST_MAPPING;
    public static final ImageDescriptor DESC_OBJS_ANNOTATION_BEAN;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT;
    public static final ImageDescriptor DESC_OBJS_JAVA_FILE;
    public static final ImageDescriptor DESC_OBJS_BROWSER;
    public static final ImageDescriptor DESC_OBJS_ORIENTATION_HORIZONTAL;
    public static final ImageDescriptor DESC_OBJS_ORIENTATION_VERTICAL;

    static {
        try {
            ICON_BASE_URL = new URL(MetadataPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException malformedURLException) {}
        DESC_OBJS_ASPECT = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_ASPECT);
        DESC_OBJS_AROUND_ADVICE = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_AROUND_ADVICE);
        DESC_OBJS_BEFORE_ADVICE = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_BEFORE_ADVICE);
        DESC_OBJS_AFTER_ADVICE = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_AFTER_ADVICE);
        DESC_OBJS_DECLARE_PARENTS = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_DECLARE_PARENTS);
        DESC_OBJS_DECLARE_WARNING = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_DECLARE_WARNING);
        DESC_OBJS_DECLARE_ERROR = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_DECLARE_ERROR);
        DESC_OBJS_DECLARE_ANNOTATION = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_DECLARE_ANNOTATION);
        DESC_OBJS_POINTCUT = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_POINTCUT);
        DESC_OBJS_TX = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_TX);
        DESC_OBJS_ANNOTATION = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_ANNOTATION);
        DESC_OBJS_REQUEST_MAPPING = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_REQUEST_MAPPING);
        DESC_OBJS_ANNOTATION_BEAN = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_ANNOTATION_BEAN);
        DESC_OBJS_BREAKPOINT = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_BREAKPOINT);
        DESC_OBJS_JAVA_FILE = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_JAVA_FILE);
        DESC_OBJS_BROWSER = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_BROWSER);
        DESC_OBJS_ORIENTATION_HORIZONTAL = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_ORIENTATION_HORIZONTAL);
        DESC_OBJS_ORIENTATION_VERTICAL = MetadataUIImages.createManaged(OBJECT, IMG_OBJS_ORIENTATION_VERTICAL);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return MetadataPlugin.getDefault().getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        MetadataUIImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        MetadataUIImages.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        action.setImageDescriptor(MetadataUIImages.create("e" + type, relPath));
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)MetadataUIImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)MetadataUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)MetadataUIImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

