/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.search.TextSearchControl;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.forms.widgets.FormFonts;
import org.eclipse.ui.part.PageBook;
import org.osgi.framework.Bundle;
import org.springsource.ide.eclipse.commons.core.ResourceProvider;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.StsUiImages;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.AggregateFeedJob;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.CachedFeedsManager;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.DashboardEditorInput;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.FeedsReader;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.MultiPageDashboardEditor;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.UpdateNotification;
import org.springsource.ide.eclipse.dashboard.ui.AbstractDashboardPage;
import org.springsource.ide.eclipse.dashboard.ui.AbstractDashboardPart;

public class DashboardMainPage
extends AbstractDashboardPage
implements PropertyChangeListener {
    public static final String RESOURCE_DASHBOARD_BUG_TRACKER = "dashboard.bug.tracker";
    public static final String RESOURCE_DASHBOARD_FEEDS_BLOGS = "dashboard.feeds.blogs";
    public static final String RESOURCE_DASHBOARD_FEEDS_UPDATE = "dashboard.feeds.update";
    public static final String RESOURCE_DASHBOARD_LOGO = "dashboard.logo";
    public static final String RESOURCE_DASHBOARD_SUBSCRIBE = "dashboard.subscribe";
    public static final String RESOURCE_DASHBOARD_NEW_AND_NOTEWORTHY = "dashboard.new.and.noteworthy";
    public static final String RESOURCE_DASHBOARD_PRODUCT_PAGE = "dashboard.product.page";
    public static final String RESOURCE_DASHBOARD_SEARCH = "dashboard.search";
    public static final String RESOURCE_DASHBOARD_SUPPORT_COMMERCIAL = "dashboard.support.commercial";
    public static final String RESOURCE_DASHBOARD_SUPPORT_COMMUNITY = "dashboard.support.community";
    private static final String LOGO_SPRINGSOURCE = "prod/spring_logo_transparent.png";
    private static final String SUBSCRIBE_SPRINGSOURCE = "prod/newsletter_subscription.gif";
    public static final String PAGE_ID = "com.springsource.sts.ide.ui.dashboard.page.overview";
    private static final Pattern PATTERN = Pattern.compile("<img.*href=\"(.*?)\"/>");
    private final MultiPageDashboardEditor dashboardEditor;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private Text searchBox;
    private IPreferenceStore prefStore;
    private Color feedColor;
    private Section updateSection;
    private Section helpSection;
    private static final String PROXY_PREF_PAGE_ID = "org.eclipse.ui.net.NetPreferences";
    private static final String ELEMENT_CLASS = "class";
    private static final String ELEMENT_ICON = "icon";
    private static final String ELEMENT_NAME = "name";
    private static final String EXTENSION_ID_NEW_WIZARD = "org.eclipse.ui.newWizards";
    private static final String GRAILS_WIZARD_ID = "org.grails.ide.eclipse.ui.wizard.newGrailsProjectWizard";
    private static final String ROO_WIZARD_ID = "com.springsource.sts.roo.ui.wizard.newRooProjectWizard";
    private static final String GROOVY_WIZARD_ID = "org.codehaus.groovy.eclipse.ui.groovyProjectWizard";
    private static final String SPRING_WIZARD_ID = "com.springsource.sts.wizard.template";
    private static final String JAVA_WIZARD_ID = "org.eclipse.jdt.ui.wizards.JavaProjectWizard";
    private static final int UPDATE_INDENTATION = 22;
    private static final int UPDATE_TEXT_WRAP_INDENT = 65;
    private static final int FEEDS_TEXT_WRAP_INDENT = 80;
    private final List<SyndEntry> displayedEntries;
    private Composite feedsComposite;
    private ScrolledComposite feedsScrolled;
    private static final String ICON_BLOG_INCOMING = "rss/overlay-incoming.png";
    private static final String ICON_BLOG_BLANK = "rss/blank.png";
    private static final int FEEDS_DESCRIPTION_MAX = 200;
    protected static final String URL_CONFIGURATION_ID = "com.springsource.sts.ide.ui.preferencePage";
    public static final int SWT_UNDERLINE_LINK = 4;
    private Set<Control> feedControls;
    private Action refreshFeedsAction;
    private Action refreshUpdatesAction;
    private ScrolledComposite updateScrolled;
    private Set<AggregateFeedJob> unfinishedJobs;
    private List<AbstractDashboardPart> parts;

    public DashboardMainPage(MultiPageDashboardEditor editor) {
        super((FormEditor)editor, PAGE_ID, "Dashboard");
        this.dashboardEditor = editor;
        this.displayedEntries = new ArrayList<SyndEntry>();
    }

    public void cancelUnfinishedJobs() {
        for (AggregateFeedJob job : this.unfinishedJobs) {
            job.cancel();
        }
        this.unfinishedJobs.clear();
    }

    public void dispose() {
        ResourceProvider.getInstance().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.feedColor != null) {
            this.feedColor.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals(RESOURCE_DASHBOARD_FEEDS_BLOGS)) {
            this.refreshFeedsAction.run();
        } else if (propertyName.equals(RESOURCE_DASHBOARD_FEEDS_UPDATE)) {
            this.refreshUpdatesAction.run();
        }
    }

    private void addImages(FormText text, String description) {
        if (description.contains("<img")) {
            Matcher matcher = PATTERN.matcher(description);
            while (matcher.find()) {
                String url = matcher.group(1);
                text.setImage(url, IdeUiPlugin.getImage(url));
            }
        }
    }

    private void adjustCollapsableSections() {
        GridDataFactory.fillDefaults().grab(true, this.updateSection.isExpanded()).applyTo((Control)this.updateSection);
        for (AbstractDashboardPart part : this.parts) {
            if (!(part.getControl() instanceof Section)) continue;
            Section section = (Section)part.getControl();
            GridDataFactory.fillDefaults().grab(true, section.isExpanded()).applyTo((Control)section);
        }
        GridDataFactory.fillDefaults().grab(true, !this.updateSection.isExpanded() && this.areAllContributedSectionsCollapsed() && this.helpSection.isExpanded()).applyTo((Control)this.helpSection);
        this.form.getBody().layout(true, true);
        this.form.reflow(true);
    }

    private boolean areAllContributedSectionsCollapsed() {
        for (AbstractDashboardPart part : this.parts) {
            if (!(part.getControl() instanceof Section) || !((Section)part.getControl()).isExpanded()) continue;
            return false;
        }
        return true;
    }

    private void clearText() {
        if (this.searchBox != null && !this.searchBox.isDisposed()) {
            this.searchBox.setText("");
        }
    }

    private void createFeedsSection(Composite parent, final String title, FeedType feedType, String feedName) {
        String[] urls;
        final Section section = new Section(parent, 256){

            public void redraw() {
                GridData compositeData = (GridData)DashboardMainPage.this.feedsScrolled.getLayoutData();
                compositeData.widthHint = this.getSize().x - 35;
                compositeData.heightHint = this.getSize().y - 40;
                compositeData.grabExcessHorizontalSpace = false;
                compositeData.grabExcessVerticalSpace = false;
                super.redraw();
            }
        };
        this.form.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData data = (GridData)section.getLayoutData();
                data.heightHint = ((DashboardMainPage)DashboardMainPage.this).form.getSize().y - 80;
            }
        });
        this.toolkit.adapt((Composite)section);
        section.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        section.setTitleBarBackground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        section.setTitleBarBorderColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
        section.setFont(FormFonts.getInstance().getBoldFont(this.getSite().getShell().getDisplay(), section.getFont()));
        section.setText(title);
        section.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).hint(300, 300).applyTo((Control)section);
        Composite headerComposite = this.toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.createControl(headerComposite);
        final PageBook pagebook = new PageBook((Composite)section, 0);
        this.toolkit.adapt((Composite)pagebook);
        pagebook.setLayoutData((Object)new GridLayout());
        final Composite disclaimer = this.createDisclaimer((Composite)pagebook);
        this.feedsScrolled = new ScrolledComposite((Composite)pagebook, 512);
        this.feedsScrolled.setExpandVertical(false);
        this.feedsScrolled.setLayout((Layout)new GridLayout());
        this.feedsScrolled.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.feedsScrolled);
        this.toolkit.adapt((Composite)this.feedsScrolled);
        this.feedsComposite = this.toolkit.createComposite((Composite)this.feedsScrolled);
        this.feedsComposite.setLayout((Layout)new TableWrapLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.feedsComposite);
        this.feedsScrolled.setContent((Control)this.feedsComposite);
        this.feedsComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GridData data = (GridData)DashboardMainPage.this.feedsComposite.getLayoutData();
                data.widthHint = section.getSize().x - 80;
                data.heightHint = ((DashboardMainPage)DashboardMainPage.this).form.getSize().y - 50;
            }
        });
        section.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridData data = (GridData)DashboardMainPage.this.feedsScrolled.getLayoutData();
                data.heightHint = ((DashboardMainPage)DashboardMainPage.this).form.getSize().y - 50;
                data.grabExcessVerticalSpace = false;
                DashboardMainPage.this.feedsScrolled.setSize(section.getSize().x - 40, ((DashboardMainPage)DashboardMainPage.this).form.getSize().y - 50);
                for (Control feedControl : DashboardMainPage.this.feedControls) {
                    if (feedControl.isDisposed()) continue;
                    ((TableWrapData)feedControl.getLayoutData()).maxWidth = section.getSize().x - 80;
                }
                DashboardMainPage.this.feedsComposite.pack();
            }
        });
        this.feedControls = new HashSet<Control>();
        final HashMap<String, Object> springMap = new HashMap<String, Object>();
        String[] stringArray = urls = ResourceProvider.getUrls((String)RESOURCE_DASHBOARD_FEEDS_BLOGS);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            springMap.put(url, null);
            ++n2;
        }
        this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FeedsReader reader = new FeedsReader();
                CachedFeedsManager manager = new CachedFeedsManager(title, springMap, reader);
                try {
                    manager.readCachedFeeds(null);
                    HashSet entries = new HashSet();
                    for (SyndFeed entry : reader.getFeeds()) {
                        entries.addAll(entry.getEntries());
                    }
                    if (!DashboardMainPage.this.getManagedForm().getForm().isDisposed()) {
                        DashboardMainPage.this.displayFeeds(entries, DashboardMainPage.this.feedsComposite, DashboardMainPage.this.feedsScrolled, pagebook, (Control)disclaimer, section);
                    }
                }
                catch (IllegalArgumentException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "An unexpected error occurred while retrieving feed content from cache.", (Throwable)e));
                }
                catch (FeedException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "An unexpected error occurred while retrieving feed content from cache.", (Throwable)e));
                }
            }
        });
        this.refreshFeedsAction = new Action("Refresh Feeds", CommonImages.REFRESH){

            public void run() {
                Map<String, String> springMap = DashboardMainPage.getFeedsMap();
                DashboardMainPage.this.displayFeeds(DashboardMainPage.this.feedsComposite, DashboardMainPage.this.feedsScrolled, pagebook, (Control)disclaimer, springMap, title, section);
            }
        };
        Action configureURLsAction = new Action("Configure URLs", StsUiImages.RSS_CONFIGURE){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)DashboardMainPage.this.getSite().getShell(), (String)DashboardMainPage.URL_CONFIGURATION_ID, (String[])new String[]{DashboardMainPage.URL_CONFIGURATION_ID}, null);
                dialog.open();
            }
        };
        section.setClient((Control)pagebook);
        section.setTextClient((Control)headerComposite);
        toolBarManager.add((IAction)configureURLsAction);
        toolBarManager.add((IAction)this.refreshFeedsAction);
        toolBarManager.update(true);
        this.refreshFeedsAction.run();
    }

    private Composite createDisclaimer(Composite parent) {
        FormText disclaimer = this.toolkit.createFormText(parent, true);
        disclaimer.setForeground(this.feedColor);
        disclaimer.setText("<form><p>No entries found. Ensure <a href=\"proxy\">firewall and proxy settings</a> are appropriately configured.</p></form>", true, false);
        disclaimer.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if ("proxy".equals(e.data)) {
                    PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)DashboardMainPage.PROXY_PREF_PAGE_ID, null, null);
                    dialog.open();
                }
            }
        });
        return disclaimer;
    }

    private void createHeader() {
        IManagedForm headerForm = this.dashboardEditor.getHeaderForm();
        Form topForm = headerForm.getForm().getForm();
        IToolBarManager toolBarManager = topForm.getToolBarManager();
        toolBarManager.removeAll();
        toolBarManager.update(true);
        toolBarManager.add((IContributionItem)new ControlContribution("springSource_search"){

            protected Control createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setBackground(null);
                GridLayout layout = new GridLayout(2, false);
                layout.marginRight = 0;
                layout.marginHeight = 0;
                layout.marginTop = 5;
                layout.verticalSpacing = 1;
                composite.setLayout((Layout)layout);
                GridDataFactory.fillDefaults().align(4, 1024).grab(false, true).applyTo((Control)composite);
                DashboardMainPage.this.createSearchBox(composite);
                return composite;
            }
        });
        toolBarManager.add((IContributionItem)new ControlContribution("subscribe"){

            protected Control createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                composite.setBackground(null);
                GridLayout layout = new GridLayout(2, false);
                layout.marginRight = 2;
                layout.marginLeft = 0;
                layout.marginHeight = 0;
                layout.marginTop = 12;
                layout.verticalSpacing = 1;
                composite.setLayout((Layout)layout);
                GridDataFactory.fillDefaults().align(4, 1024).grab(false, true).applyTo((Control)composite);
                Button subscribeButton = new Button(composite, 8);
                subscribeButton.setText("Subscribe");
                subscribeButton.setImage(IdeUiPlugin.getImageDescriptor(DashboardMainPage.SUBSCRIBE_SPRINGSOURCE).createImage());
                subscribeButton.setForeground(parent.getDisplay().getSystemColor(16));
                subscribeButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_SUBSCRIBE));
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return composite;
            }
        });
        toolBarManager.add((IAction)new Action("Spring", IdeUiPlugin.getImageDescriptor(LOGO_SPRINGSOURCE)){

            public void run() {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_LOGO));
            }
        });
        toolBarManager.update(true);
    }

    private void createHelpSection(Composite parent) {
        this.helpSection = this.toolkit.createSection(parent, 258);
        this.helpSection.setText("Help and Documentation");
        this.helpSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.helpSection);
        Composite composite = this.toolkit.createComposite((Composite)this.helpSection);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        Hyperlink link = this.toolkit.createHyperlink(composite, "Community Support Forums", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_SUPPORT_COMMUNITY));
            }
        });
        link = this.toolkit.createHyperlink(composite, "New and Noteworthy", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_NEW_AND_NOTEWORTHY));
            }
        });
        link = this.toolkit.createHyperlink(composite, "Issue and Bug Tracker", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_BUG_TRACKER));
            }
        });
        link = this.toolkit.createHyperlink(composite, "Extensions", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    IWorkbenchPage page = DashboardMainPage.this.getSite().getWorkbenchWindow().getActivePage();
                    FormEditor editor = (FormEditor)page.openEditor((IEditorInput)DashboardEditorInput.INSTANCE, MultiPageDashboardEditor.EDITOR_ID);
                    editor.setActivePage("extensions");
                }
                catch (PartInitException ex) {
                    StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not open dashboard", (Throwable)ex));
                }
            }
        });
        link = this.toolkit.createHyperlink(composite, "SpringSource Commercial Support", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_SUPPORT_COMMERCIAL));
            }
        });
        link = this.toolkit.createHyperlink(composite, "Product Page", 4);
        GridDataFactory.fillDefaults().applyTo((Control)link);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl((String)ResourceProvider.getUrl((String)DashboardMainPage.RESOURCE_DASHBOARD_PRODUCT_PAGE));
            }
        });
        this.helpSection.setClient((Control)composite);
        this.setUpExpandableSection(this.helpSection, "org.springsource.ide.eclipse.dashboard.uidashboard.help.collapse", true);
    }

    private void createNewProjectFromExtension(final Composite container, final IConfigurationElement element) {
        if (element == null) {
            return;
        }
        try {
            Object object = WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)ELEMENT_CLASS);
            if (!(object instanceof INewWizard)) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not load " + object.getClass().getCanonicalName() + " must implement " + INewWizard.class.getCanonicalName()));
                return;
            }
            String title = element.getAttribute(ELEMENT_NAME);
            String pathName = element.getAttribute(ELEMENT_ICON);
            String plugin = element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)plugin);
            URL iconLocation = bundle.getResource(pathName);
            Image image = null;
            if (element.getAttribute("id").equals(JAVA_WIZARD_ID)) {
                image = StsUiImages.getImage((ImageDescriptor)StsUiImages.NEW_JAVA_PROJECT);
            } else if (iconLocation != null) {
                image = StsUiImages.getImage((ImageDescriptor)ImageDescriptor.createFromURL((URL)iconLocation));
            }
            this.createNewProjectLink(container, title, image, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Object object;
                    try {
                        object = WorkbenchPlugin.createExtension((IConfigurationElement)element, (String)DashboardMainPage.ELEMENT_CLASS);
                    }
                    catch (CoreException ex) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not read dashboard extension", (Throwable)ex));
                        return;
                    }
                    if (!(object instanceof INewWizard)) {
                        StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not load " + object.getClass().getCanonicalName() + " must implement " + INewWizard.class.getCanonicalName()));
                        return;
                    }
                    INewWizard wizard = (INewWizard)object;
                    wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                    WizardDialog dialog = new WizardDialog(container.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not read dashboard extension", (Throwable)e));
        }
    }

    private void createNewProjectLink(Composite parent, String name, Image image, IHyperlinkListener listener) {
        ImageHyperlink link = this.toolkit.createImageHyperlink(parent, 0);
        link.setText(name);
        link.setImage(image);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)link);
        if (listener != null) {
            link.addHyperlinkListener(listener);
        }
    }

    private void createNewProjectsSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText("Create");
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)section);
        section.setLayout((Layout)new GridLayout());
        Composite headerComposite = this.toolkit.createComposite((Composite)section, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.createControl(headerComposite);
        section.setTextClient((Control)headerComposite);
        toolBarManager.add((IAction)new NewWizardAction(this.getSite().getWorkbenchWindow()));
        toolBarManager.update(true);
        Composite container = this.toolkit.createComposite((Composite)section);
        container.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)container);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_NEW_WIZARD);
        IExtension[] extensions = extensionPoint.getExtensions();
        IConfigurationElement[] foundElements = new IConfigurationElement[6];
        String[] ids = new String[]{JAVA_WIZARD_ID, SPRING_WIZARD_ID, ROO_WIZARD_ID, GROOVY_WIZARD_ID, GRAILS_WIZARD_ID};
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String id = element.getAttribute("id");
                int i = 0;
                while (i < ids.length) {
                    if (ids[i].equals(id) && element.getAttribute(ELEMENT_CLASS) != null && element.getAttribute(ELEMENT_NAME) != null && element.getAttribute(ELEMENT_ICON) != null) {
                        foundElements[i] = element;
                    }
                    ++i;
                }
                ++n4;
            }
            ++n2;
        }
        iExtensionArray = foundElements;
        n = foundElements.length;
        n2 = 0;
        while (n2 < n) {
            IExtension element = iExtensionArray[n2];
            this.createNewProjectFromExtension(container, (IConfigurationElement)element);
            ++n2;
        }
        section.setClient((Control)container);
    }

    private void createSearchBox(Composite composite) {
        TextSearchControl searchControl = new TextSearchControl(composite, false, null);
        searchControl.getTextControl().setMessage("Search spring.io");
        GridDataFactory.fillDefaults().grab(false, true).align(4, 0x1000000).hint(200, -1).applyTo((Control)searchControl);
        this.searchBox = searchControl.getTextControl();
        this.searchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b' && e.doit) {
                    DashboardMainPage.this.clearText();
                }
            }
        });
        searchControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    DashboardMainPage.this.clearText();
                } else {
                    DashboardMainPage.this.searchSpringSource();
                }
            }
        });
    }

    private void createUpdateSection(Composite parent) {
        this.updateSection = new Section(parent, 258){

            public void redraw() {
                if (DashboardMainPage.this.getStoredExpandedState("org.springsource.ide.eclipse.dashboard.uidashboard.update.collapse", true)) {
                    GridData compositeData = (GridData)DashboardMainPage.this.updateScrolled.getLayoutData();
                    compositeData.widthHint = this.getSize().x - 55;
                    compositeData.heightHint = this.getSize().y - 40;
                    compositeData.grabExcessHorizontalSpace = false;
                    compositeData.grabExcessVerticalSpace = false;
                }
                super.redraw();
            }
        };
        this.toolkit.adapt((Composite)this.updateSection);
        this.updateSection.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.updateSection.setTitleBarBackground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG"));
        this.updateSection.setTitleBarBorderColor(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.updateSection.setFont(FormFonts.getInstance().getBoldFont(this.getSite().getShell().getDisplay(), this.updateSection.getFont()));
        this.updateSection.setText("Updates");
        this.updateSection.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, this.getStoredExpandedState("org.springsource.ide.eclipse.dashboard.uidashboard.update.collapse", true)).applyTo((Control)this.updateSection);
        this.setUpExpandableSection(this.updateSection, "org.springsource.ide.eclipse.dashboard.uidashboard.update.collapse", true);
        Composite headerComposite = this.toolkit.createComposite((Composite)this.updateSection, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        headerComposite.setLayout((Layout)rowLayout);
        headerComposite.setBackground(null);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        toolBarManager.createControl(headerComposite);
        this.updateSection.setTextClient((Control)headerComposite);
        final PageBook pagebook = new PageBook((Composite)this.updateSection, 0);
        this.toolkit.adapt((Composite)pagebook);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pagebook);
        final Composite disclaimer = this.createDisclaimer((Composite)pagebook);
        this.updateScrolled = new ScrolledComposite((Composite)pagebook, 512);
        this.updateScrolled.setExpandVertical(false);
        this.updateScrolled.setLayout((Layout)new GridLayout());
        this.updateScrolled.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.updateScrolled);
        this.toolkit.adapt((Composite)this.updateScrolled);
        final Composite composite = this.toolkit.createComposite((Composite)this.updateScrolled);
        this.updateScrolled.setContent((Control)composite);
        composite.setLayout((Layout)new TableWrapLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.displayUpdates(composite, pagebook, disclaimer);
        this.refreshUpdatesAction = new Action("Refresh Updates", CommonImages.REFRESH){

            public void run() {
                DashboardMainPage.this.displayUpdates(composite, pagebook, disclaimer);
            }
        };
        toolBarManager.add((IAction)this.refreshUpdatesAction);
        toolBarManager.update(true);
        pagebook.showPage((Control)composite);
        this.updateSection.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (DashboardMainPage.this.updateSection.isExpanded()) {
                    GridData data = (GridData)DashboardMainPage.this.updateScrolled.getLayoutData();
                    data.grabExcessVerticalSpace = false;
                    DashboardMainPage.this.updateScrolled.setSize(((DashboardMainPage)DashboardMainPage.this).updateSection.getSize().x - 14, ((DashboardMainPage)DashboardMainPage.this).updateSection.getSize().y - 33);
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        ((TableWrapData)child.getLayoutData()).maxWidth = ((DashboardMainPage)DashboardMainPage.this).updateSection.getSize().x - 65;
                        ++n2;
                    }
                    composite.pack();
                }
            }
        });
        this.updateSection.setClient((Control)pagebook);
    }

    private void displayFeed(SyndEntry entry, Composite composite, final Section section, int pos, Control[] children) {
        FormText text;
        ImageHyperlink link;
        if (pos < children.length / 2) {
            link = (ImageHyperlink)children[pos * 2];
            link.setVisible(true);
            text = (FormText)children[pos * 2 + 1];
            text.setVisible(true);
        } else {
            final ImageHyperlink newLink = this.toolkit.createImageHyperlink(composite, 0);
            this.feedControls.add((Control)newLink);
            link = newLink;
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Object source = e.getSource();
                    if (source instanceof ImageHyperlink && ((ImageHyperlink)source).getData() != null) {
                        SyndEntry entry = (SyndEntry)((ImageHyperlink)source).getData();
                        String url = entry.getLink();
                        if (url == null) {
                            return;
                        }
                        int urlPos = url.indexOf("?");
                        String newUrl = url;
                        if (urlPos > 0) {
                            newUrl = String.valueOf(url.substring(0, urlPos + 1)) + url.substring(urlPos + 1).replaceAll("\\?", "&");
                        }
                        TasksUiUtil.openUrl((String)url);
                        DashboardMainPage.this.prefStore.setValue("org.springsource.ide.eclipse.dashboard.uidashboard.feed.item.state:" + newUrl, true);
                        IdeUiPlugin.getDefault().savePluginPreferences();
                        newLink.setImage(IdeUiPlugin.getImage(DashboardMainPage.ICON_BLOG_BLANK));
                    }
                }
            });
            text = new FormText(composite, 786498);
            text.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
            this.feedControls.add((Control)text);
            final TableWrapData data = new TableWrapData();
            data.indent = 22;
            data.maxWidth = section.getSize().x - 80;
            data.grabVertical = true;
            text.setLayoutData((Object)data);
            text.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    data.maxWidth = section.getSize().x - 80;
                }
            });
            text.setForeground(this.feedColor);
            text.setBackground(this.toolkit.getColors().getBackground());
        }
        String title = entry.getTitle();
        Date entryDate = new Date(0L);
        entryDate = entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
        String dateString = "";
        if (entryDate != null) {
            dateString = DateFormat.getDateInstance(2).format(entryDate);
        }
        String entryAuthor = "";
        if (entry.getAuthor() != null && entry.getAuthor().trim() != "") {
            entryAuthor = " by " + entry.getAuthor();
        }
        if (dateString.length() > 0 && entryAuthor.length() > 0) {
            link.setText(this.removeHtmlEntities(title));
        }
        TableWrapData linkData = new TableWrapData();
        if (!this.prefStore.getBoolean("org.springsource.ide.eclipse.dashboard.uidashboard.feed.item.state:" + entry.getLink())) {
            link.setImage(IdeUiPlugin.getImage(ICON_BLOG_INCOMING));
            linkData.indent = 0;
        } else {
            linkData.indent = 21;
        }
        link.setLayoutData((Object)linkData);
        link.setData((Object)entry);
        String description = this.trimText(this.getDescription(entry));
        text.setText(String.valueOf(description) + " (" + dateString + entryAuthor + ")", false, false);
    }

    private void displayFeeds(final Composite composite, final ScrolledComposite scrolled, final PageBook pagebook, final Control disclaimer, Map<String, String> map, String feedName, final Section section) {
        final AggregateFeedJob job = new AggregateFeedJob(map, feedName);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DashboardMainPage.this.unfinishedJobs.remove((Object)job);
                IWorkbenchPartSite site = DashboardMainPage.this.getSite();
                if (site != null && site.getShell() != null && !site.getShell().isDisposed() && site.getShell().getDisplay() != null && !site.getShell().getDisplay().isDisposed()) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Map<SyndEntry, SyndFeed> entryToFeed = job.getFeedReader().getFeedsWithEntries();
                            Set<SyndEntry> entries = entryToFeed.keySet();
                            if (!DashboardMainPage.this.getManagedForm().getForm().isDisposed()) {
                                DashboardMainPage.this.displayFeeds(entries, composite, scrolled, pagebook, disclaimer, section);
                            }
                        }
                    });
                }
            }
        });
        this.unfinishedJobs.add(job);
        job.schedule();
    }

    private void displayFeeds(Set<SyndEntry> entries, Composite composite, ScrolledComposite scrolled, PageBook pagebook, Control disclaimer, Section section) {
        ArrayList<SyndEntry> sortedEntries = new ArrayList<SyndEntry>(entries);
        Collections.sort(sortedEntries, new Comparator<SyndEntry>(){

            @Override
            public int compare(SyndEntry o1, SyndEntry o2) {
                Date o2Date;
                Date o1Date = o1.getPublishedDate() != null ? o1.getPublishedDate() : o1.getUpdatedDate();
                Date date = o2Date = o2.getPublishedDate() != null ? o2.getPublishedDate() : o2.getUpdatedDate();
                if (o1Date == null && o2Date == null) {
                    return 0;
                }
                if (o1Date == null) {
                    return -1;
                }
                if (o2Date == null) {
                    return 1;
                }
                return o2Date.compareTo(o1Date);
            }
        });
        if (sortedEntries.isEmpty()) {
            pagebook.showPage(disclaimer);
            return;
        }
        if (this.displayedEntries.containsAll(entries) && entries.containsAll(this.displayedEntries)) {
            return;
        }
        this.displayedEntries.clear();
        this.displayedEntries.addAll(entries);
        Control[] children = composite.getChildren();
        int counter = 0;
        for (SyndEntry entry : sortedEntries) {
            this.displayFeed(entry, composite, section, counter, children);
            ++counter;
        }
        int i = counter * 2;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        pagebook.showPage((Control)scrolled);
        composite.pack(true);
    }

    private void displayUpdate(final SyndEntry entry, String severity, Composite composite, int pos, Control[] children) {
        FormText text;
        ImageHyperlink link;
        if (pos < children.length / 2) {
            link = (ImageHyperlink)children[pos * 2];
            link.setVisible(true);
            text = (FormText)children[pos * 2 + 1];
            text.setVisible(true);
        } else {
            link = this.toolkit.createImageHyperlink(composite, 0);
            text = new FormText(composite, 786498);
            text.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
            final TableWrapData data = new TableWrapData();
            data.indent = 22;
            data.maxWidth = this.updateSection.getSize().x - 65;
            text.setLayoutData((Object)data);
            text.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    data.maxWidth = ((DashboardMainPage)DashboardMainPage.this).updateSection.getSize().x - 65;
                }
            });
            text.setBackground(this.toolkit.getColors().getBackground());
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (e.data instanceof String) {
                        TasksUiUtil.openUrl((String)((String)e.data));
                    }
                }
            });
        }
        link.setText(entry.getTitle());
        TableWrapData linkData = new TableWrapData();
        if ("important".equals(severity)) {
            link.setImage(StsUiImages.getImage((ImageDescriptor)StsUiImages.IMPORTANT));
            linkData.indent = 0;
        } else if ("warning".equals(severity)) {
            link.setImage(StsUiImages.getImage((ImageDescriptor)StsUiImages.WARNING));
            linkData.indent = 0;
        } else {
            linkData.indent = 21;
        }
        link.setLayoutData((Object)linkData);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String url = entry.getLink();
                if (url == null) {
                    return;
                }
                TasksUiUtil.openUrl((String)url);
            }
        });
        String description = this.getDescription(entry);
        if (entry.getPublishedDate() != null && description.endsWith("</p></form>")) {
            String dateString = DateFormat.getDateInstance(2).format(entry.getPublishedDate());
            description = description.replace("</p></form>", " (" + dateString + ")</p></form>");
        } else if (entry.getPublishedDate() != null) {
            String dateString = DateFormat.getDateInstance(2).format(entry.getPublishedDate());
            description = String.valueOf(description) + " (" + dateString + ")";
        }
        text.setText(description, description.startsWith("<form>"), true);
        text.setForeground(this.feedColor);
        text.setBackground(this.toolkit.getColors().getBackground());
        this.addImages(text, description);
    }

    private void displayUpdates(final Composite composite, final PageBook pagebook, final Composite disclaimer) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(ResourceProvider.getUrl((String)RESOURCE_DASHBOARD_FEEDS_UPDATE), null);
        final AggregateFeedJob job = new AggregateFeedJob(map, "Updates");
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DashboardMainPage.this.unfinishedJobs.remove((Object)job);
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (DashboardMainPage.this.getManagedForm().getForm().isDisposed()) {
                                return;
                            }
                            List<UpdateNotification> notifications = job.getNotifications();
                            if (notifications.isEmpty()) {
                                pagebook.showPage((Control)disclaimer);
                                return;
                            }
                            Collections.sort(notifications, new Comparator<UpdateNotification>(){

                                @Override
                                public int compare(UpdateNotification o1, UpdateNotification o2) {
                                    return this.getDate(o2).compareTo(this.getDate(o1));
                                }

                                private Date getDate(UpdateNotification o) {
                                    Date d;
                                    SyndEntry e;
                                    if (o != null && (e = o.getEntry()) != null && (d = e.getPublishedDate()) != null) {
                                        return d;
                                    }
                                    return new Date(0L);
                                }
                            });
                            int counter = 0;
                            Control[] children = composite.getChildren();
                            for (UpdateNotification notification : notifications) {
                                DashboardMainPage.this.displayUpdate(notification.getEntry(), notification.getSeverity(), composite, counter, children);
                                ++counter;
                            }
                            int i = counter * 2;
                            while (i < children.length) {
                                children[i].dispose();
                                ++i;
                            }
                            composite.changed(composite.getChildren());
                            composite.pack(true);
                            composite.redraw();
                            composite.getParent().redraw();
                        }
                    });
                }
            }
        });
        this.unfinishedJobs.add(job);
        job.schedule();
    }

    private int findEndOfWord(StringBuilder sb, int pos) {
        Pattern pattern = Pattern.compile("\\w");
        while (pos < sb.length()) {
            if (pattern.matcher(sb.subSequence(pos, pos + 1)).matches()) {
                ++pos;
                continue;
            }
            return pos;
        }
        return pos;
    }

    private String getDescription(SyndEntry entry) {
        Object obj;
        List nestedContent;
        SyndContent content = entry.getDescription();
        if (content == null && !(nestedContent = entry.getContents()).isEmpty() && (obj = nestedContent.get(0)) instanceof SyndContent) {
            content = (SyndContent)obj;
        }
        if (content == null) {
            return "";
        }
        String value = content.getValue();
        if (value == null) {
            return "";
        }
        if (value.startsWith("<form>")) {
            return value;
        }
        return this.removeHtmlEntities(value);
    }

    private boolean getStoredExpandedState(String prefId, boolean defaultExpanded) {
        int storedState = this.prefStore.getInt(prefId);
        if (storedState == 2) {
            return true;
        }
        if (storedState == 1) {
            return false;
        }
        return defaultExpanded;
    }

    private String removeHtmlEntities(String value) {
        StringBuilder result = new StringBuilder();
        boolean tagOpened = false;
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char currChar = cArray[n2];
            if (currChar == '<') {
                tagOpened = true;
            } else if (currChar == '>') {
                tagOpened = false;
            } else if (!tagOpened) {
                result.append(currChar);
            }
            ++n2;
        }
        return StringEscapeUtils.unescapeHtml((String)result.toString());
    }

    private void searchSpringSource() {
        String searchTerms = this.searchBox.getText();
        String url = String.valueOf(ResourceProvider.getUrl((String)RESOURCE_DASHBOARD_SEARCH)) + searchTerms.replaceAll(" ", "+");
        TasksUiUtil.openUrl((String)url);
    }

    private void setUpExpandableSection(final Section section, final String prefId, boolean defaultExpanded) {
        section.setExpanded(this.getStoredExpandedState(prefId, defaultExpanded));
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    DashboardMainPage.this.prefStore.setValue(prefId, 2);
                } else {
                    DashboardMainPage.this.prefStore.setValue(prefId, 1);
                }
                if (DashboardMainPage.this.isContributedSection(section)) {
                    DashboardMainPage.this.updateSection.setExpanded(false);
                    DashboardMainPage.this.prefStore.setValue("org.springsource.ide.eclipse.dashboard.uidashboard.update.collapse", 1);
                }
                for (AbstractDashboardPart part : DashboardMainPage.this.parts) {
                    if (section.equals(part.getControl()) || !(part.getControl() instanceof Section)) continue;
                    ((Section)part.getControl()).setExpanded(false);
                    DashboardMainPage.this.prefStore.setValue(DashboardMainPage.this.getExpansionPropertyId(part), 1);
                }
                DashboardMainPage.this.adjustCollapsableSections();
            }
        });
    }

    private boolean isContributedSection(Section section) {
        for (AbstractDashboardPart part : this.parts) {
            if (!section.equals(part.getControl())) continue;
            return true;
        }
        return false;
    }

    private String trimText(String s) {
        s = StringEscapeUtils.unescapeHtml((String)s);
        s = s.replace("\n", " ");
        s = s.replace("\t", " ");
        String[] vals = s.split(" ");
        StringBuilder sb = new StringBuilder();
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (v.trim().length() > 0) {
                sb.append(v).append(" ");
            }
            ++n2;
        }
        if (sb.length() > 200) {
            return String.valueOf(sb.substring(0, this.findEndOfWord(sb, 200))) + " ...";
        }
        return sb.toString();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.form = managedForm.getForm();
        this.unfinishedJobs = new CopyOnWriteArraySet<AggregateFeedJob>();
        this.feedColor = new Color((Device)Display.getDefault(), 70, 70, 70);
        this.toolkit.decorateFormHeading(this.form.getForm());
        this.prefStore = IdeUiPlugin.getDefault().getPreferenceStore();
        GridLayout compositeLayout = new GridLayout(2, true);
        compositeLayout.marginHeight = 0;
        compositeLayout.marginTop = 5;
        compositeLayout.verticalSpacing = 0;
        Composite body = this.form.getBody();
        body.setLayout((Layout)compositeLayout);
        Composite leftComposite = this.toolkit.createComposite(body);
        leftComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)leftComposite);
        Composite rightComposite = this.toolkit.createComposite(body);
        rightComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)rightComposite);
        this.createHeader();
        this.createNewProjectsSection(leftComposite);
        this.createUpdateSection(leftComposite);
        this.parts = this.contributeParts(leftComposite, AbstractDashboardPart.ID_PATH_DOC);
        for (AbstractDashboardPart part : this.parts) {
            if (!(part.getControl() instanceof Section)) continue;
            String expansionProp = this.getExpansionPropertyId(part);
            Section section = (Section)part.getControl();
            GridDataFactory.fillDefaults().grab(false, this.getStoredExpandedState(expansionProp, false)).applyTo((Control)section);
            this.setUpExpandableSection(section, expansionProp, false);
        }
        this.createHelpSection(leftComposite);
        this.createFeedsSection(rightComposite, "Feeds", FeedType.BLOG, "blog");
        this.searchBox.setFocus();
        ResourceProvider.getInstance().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private String getExpansionPropertyId(AbstractDashboardPart part) {
        return String.valueOf(part.getId()) + ".expansion";
    }

    protected ScrolledForm getHeaderForm() {
        if (this.dashboardEditor == null || this.dashboardEditor.getHeaderForm() == null) {
            return null;
        }
        return this.dashboardEditor.getHeaderForm().getForm();
    }

    public static Map<String, String> getFeedsMap() {
        String[] urls;
        HashMap<String, String> springMap = new HashMap<String, String>();
        String[] stringArray = urls = ResourceProvider.getUrls((String)RESOURCE_DASHBOARD_FEEDS_BLOGS);
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            if (url != null && url.length() > 0) {
                springMap.put(url, null);
            }
            ++n2;
        }
        return springMap;
    }

    public static enum FeedType {
        BLOG,
        DOWNLOAD,
        BUZZ,
        RESEARCH;

    }
}

