/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui;

import java.util.Map;
import java.util.regex.Pattern;

public class RunInfo {
    public static final int SUITE_TYPE = 1;
    public static final int TEST_TYPE = 2;
    public static final int RESULT_TYPE = 3;
    private static final Pattern NEWLINES = Pattern.compile("\n");
    private static final Pattern CARRAGERETURN = Pattern.compile("\r");
    private String m_id;
    private String m_idWithDesc;
    private int m_type;
    private String m_suiteName = "Default suite";
    private String m_testName = "Default test";
    private String m_className;
    private String m_methodName;
    private String[] m_parameters;
    private String[] m_parameterTypes;
    private String m_stackTrace;
    protected int m_methodCount;
    protected int m_passed;
    protected int m_failed;
    protected int m_skipped;
    protected int m_successPercentageFailed;
    private int m_status;
    private String m_testDescription;
    private String m_jvmArgs;
    private Map m_environment;
    private long m_time;
    private int m_invocationCount;
    private int m_currentInvocationCount;
    private String m_instanceName;

    public RunInfo(String suiteName) {
        this.m_id = suiteName;
        this.m_suiteName = suiteName;
        this.m_type = 1;
    }

    public RunInfo(String suiteName, String testName) {
        this.m_id = String.valueOf(suiteName) + "." + testName;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
        this.m_type = 2;
    }

    public RunInfo(String suiteName, String testName, String className, String methodName, String testDesc, String instanceName, String[] params, String[] paramTypes, long time, String stackTrace, int status, int invocationCount, int currentInvocationCount) {
        this.m_id = String.valueOf(suiteName) + "." + testName + "." + className + "." + methodName + this.toString(params, paramTypes);
        this.m_idWithDesc = testDesc != null ? String.valueOf(this.m_id) + "." + testDesc : this.m_id;
        this.m_suiteName = suiteName;
        this.m_testName = testName;
        this.m_className = className;
        this.m_methodName = methodName;
        this.m_testDescription = testDesc != null ? (testDesc.equals(methodName) ? null : testDesc) : null;
        this.m_instanceName = instanceName;
        this.m_parameters = params;
        this.m_parameterTypes = paramTypes;
        this.m_time = time >= 0L ? time : 0L;
        this.m_stackTrace = stackTrace;
        this.m_type = 3;
        this.m_status = status;
        this.m_invocationCount = invocationCount;
        this.m_currentInvocationCount = currentInvocationCount;
    }

    public long getTime() {
        return this.m_time;
    }

    private String toString(String[] params, String[] paramTypes) {
        if (params == null || params.length == 0) {
            return "()";
        }
        StringBuffer buf = new StringBuffer("(");
        int i = 0;
        while (i < params.length) {
            if (i > 0) {
                buf.append(",");
            }
            if ("java.lang.String".equals(paramTypes[i]) && !"null".equals(params[i]) && !"\"\"".equals(params[i])) {
                String p = this.escapeNewLines2(params[i]);
                buf.append("\"").append(p).append("\"");
            } else {
                buf.append(params[i]);
            }
            ++i;
        }
        return buf.append(")").toString();
    }

    String escapeNewLines2(String s) {
        String result = NEWLINES.matcher(s).replaceAll("\\\\n");
        return CARRAGERETURN.matcher(result).replaceAll("\\\\r");
    }

    String escapeNewLines3(String s) {
        String result = Pattern.compile("\n").matcher(s).replaceAll("\\\\n");
        return Pattern.compile("\r").matcher(result).replaceAll("\\\\r");
    }

    public int hashCode() {
        return this.m_id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RunInfo)) {
            return false;
        }
        return this.m_id.equals(((RunInfo)o).m_id);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RunInfo[");
        buffer.append("status:" + this.getStatusName());
        buffer.append(" type:" + this.typeToString(this.m_type));
        buffer.append(" id:");
        buffer.append(this.m_id);
        if (this.m_passed != 0) {
            buffer.append(" passed:");
            buffer.append(this.m_passed);
        }
        if (this.m_failed > 0) {
            buffer.append(" failed:");
            buffer.append(this.m_failed);
        }
        if (this.m_skipped > 0) {
            buffer.append(" skipped:");
            buffer.append(this.m_skipped);
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String typeToString(int type) {
        if (type == 1) {
            return "Suite";
        }
        if (type == 2) {
            return "Test";
        }
        if (type == 3) {
            return "Result";
        }
        return "<unknown>";
    }

    public String getMethodDisplay() {
        StringBuffer buf = new StringBuffer(this.m_className);
        buf.append(this.m_methodName).append(this.getParametersDisplay()).append(this.getInvocationCountDisplay());
        return buf.toString();
    }

    public String getTestDescription() {
        if (this.m_testDescription == null || "".equals(this.m_testDescription.trim())) {
            return "";
        }
        return this.m_testDescription;
    }

    public String getParametersDisplay() {
        if (this.m_parameters == null || this.m_parameters.length == 0) {
            return "";
        }
        return this.toString(this.m_parameters, this.m_parameterTypes);
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public String getId() {
        return this.m_id;
    }

    public String getSuiteName() {
        return this.m_suiteName;
    }

    public String getTestName() {
        return this.m_testName;
    }

    public String getTestFQN() {
        return String.valueOf(this.m_suiteName) + "." + this.m_testName;
    }

    public int getType() {
        return this.m_type;
    }

    public int getStatus() {
        return this.m_status;
    }

    public String getStatusName() {
        return this.m_status == 2 ? "failure" : (this.m_status == 1 ? "success" : (this.m_status == 3 ? "skipped" : "unknown"));
    }

    public String getStackTrace() {
        return this.m_stackTrace;
    }

    public String getJvmArgs() {
        return this.m_jvmArgs;
    }

    public void setJvmArgs(String m_jvmArgs) {
        this.m_jvmArgs = m_jvmArgs;
    }

    public Map getEnvironmentVariables() {
        return this.m_environment;
    }

    public void setEnvironmentVariables(Map environment) {
        this.m_environment = environment;
    }

    public String getTreeLabel() {
        return String.valueOf(this.getMethodName()) + this.getParametersDisplay() + "(" + (float)this.getTime() / 1000.0f + " s) ";
    }

    public String getTestId() {
        return String.valueOf(this.m_suiteName) + "." + this.m_testName;
    }

    public String getMethodId() {
        return String.valueOf(this.getTestId()) + "." + this.getMethodDisplay();
    }

    public String getClassId() {
        return String.valueOf(this.getTestId()) + "." + this.m_className;
    }

    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    public int getCurrentInvocationCount() {
        return this.m_currentInvocationCount;
    }

    public String getInvocationCountDisplay() {
        int ic = this.getInvocationCount();
        if (ic > 1) {
            return " " + this.getCurrentInvocationCount() + "/" + ic;
        }
        return "";
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }
}

